/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.metadata.distribution.MediumName;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Medium_Type", propOrder={"name", "densities", "densityUnits", "volumes", "mediumFormats", "mediumNote"})
@XmlRootElement(name="MD_Medium")
public class DefaultMedium
extends ISOMetadata
implements Medium {
    private static final long serialVersionUID = 7751002701087451894L;
    private MediumName name;
    private Collection<Double> densities;
    private Unit<?> densityUnits;
    private Integer volumes;
    private Collection<MediumFormat> mediumFormats;
    private InternationalString mediumNote;

    public DefaultMedium() {
    }

    public DefaultMedium(Medium medium) {
        super(medium);
        if (medium != null) {
            this.name = medium.getName();
            this.densities = this.copyCollection(medium.getDensities(), Double.class);
            this.densityUnits = medium.getDensityUnits();
            this.volumes = medium.getVolumes();
            this.mediumFormats = this.copyCollection(medium.getMediumFormats(), MediumFormat.class);
            this.mediumNote = medium.getMediumNote();
            if (medium instanceof DefaultMedium) {
                this.identifiers = this.singleton(((DefaultMedium)medium).getIdentifier(), Identifier.class);
            }
        }
    }

    public static DefaultMedium castOrCopy(Medium medium) {
        if (medium == null || medium instanceof DefaultMedium) {
            return (DefaultMedium)medium;
        }
        return new DefaultMedium(medium);
    }

    @Override
    @XmlElement(name="name")
    public MediumName getName() {
        return this.name;
    }

    public void setName(MediumName mediumName) {
        this.checkWritePermission();
        this.name = mediumName;
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @UML(identifier="density", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getDensity() {
        return LegacyPropertyAdapter.getSingleton(this.densities, Double.class, null, DefaultMedium.class, "getDensity");
    }

    public void setDensity(Double d) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultMedium.class, "density", true, d)) {
            this.densities = this.writeCollection(LegacyPropertyAdapter.asCollection(d), this.densities, Double.class);
        }
    }

    @Override
    @Deprecated
    @XmlElement(name="density")
    public Collection<Double> getDensities() {
        this.densities = this.nonNullCollection(this.densities, Double.class);
        return this.densities;
    }

    @Deprecated
    public void setDensities(Collection<? extends Double> collection) {
        this.densities = this.writeCollection(collection, this.densities, Double.class);
    }

    @Override
    @XmlElement(name="densityUnits")
    public Unit<?> getDensityUnits() {
        return this.densityUnits;
    }

    public void setDensityUnits(Unit<?> unit) {
        this.checkWritePermission();
        this.densityUnits = unit;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="volumes")
    public Integer getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Integer n) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultMedium.class, "volumes", false, n)) {
            this.volumes = n;
        }
    }

    @Override
    @XmlElement(name="mediumFormat")
    public Collection<MediumFormat> getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return this.mediumFormats;
    }

    public void setMediumFormats(Collection<? extends MediumFormat> collection) {
        this.mediumFormats = this.writeCollection(collection, this.mediumFormats, MediumFormat.class);
    }

    @Override
    @XmlElement(name="mediumNote")
    public InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public void setMediumNote(InternationalString internationalString) {
        this.checkWritePermission();
        this.mediumNote = internationalString;
    }

    @UML(identifier="identifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, identifier);
    }
}

