/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.LogicalDependency;
import org.drools.common.NamedEntryPoint;
import org.drools.common.ObjectStore;
import org.drools.common.ObjectTypeConfigurationRegistry;
import org.drools.common.SimpleLogicalDependency;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.MapCore;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.LogicalMapCore;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitFieldTMS;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitType;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.runtime.Channel;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.HierarchyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    private org.drools.spi.Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;
    private IdentityHashMap<Object, FactHandle> identityMap;
    private LinkedList<LogicalDependency> previousJustified;
    private LinkedList<LogicalDependency> previousBlocked;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.identityMap = null;
    }

    public DefaultKnowledgeHelper(org.drools.spi.Activation activation, WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.activation = activation;
        this.identityMap = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activation = (org.drools.spi.Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
        this.identityMap = (IdentityHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
        out.writeObject(this.identityMap);
    }

    @Override
    public void setActivation(org.drools.spi.Activation agendaItem) {
        this.activation = agendaItem;
        this.previousJustified = agendaItem.getLogicalDependencies();
        this.previousBlocked = agendaItem.getBlocked();
        agendaItem.setLogicalDependencies(null);
        agendaItem.setBlocked(null);
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.activation = null;
        this.tuple = null;
        this.identityMap = null;
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public void blockActivation(Activation act) {
        AgendaItem targetMatch = (AgendaItem)act;
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep == null) {
            dep = new SimpleLogicalDependency(this.activation, targetMatch);
        }
        this.activation.addBlocked(dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isActive()) {
            targetMatch.remove();
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation(targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.removeActivation(targetMatch);
            }
        }
    }

    public void unblockAllActivations(Activation act) {
        AgendaItem targetMatch = (AgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = entry.getObject();
            ((AgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(targetMatch);
        }
    }

    @Override
    public void insert(Object object) {
        this.insert(object, false);
    }

    @Override
    public void insert(Object object, boolean dynamic) throws FactException {
        FactHandle handle = this.workingMemory.insert(object, null, dynamic, false, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().put(object, handle);
        }
    }

    @Override
    public void insertLogical(Object object) {
        this.insertLogical(object, false);
    }

    @Override
    public void insertLogical(Object object, boolean dynamic) {
        this.insertLogical(object, null, dynamic);
    }

    public void insertLogical(Object object, Object value) {
        this.insertLogical(object, value, false);
    }

    public void insertLogical(Object object, Object value, boolean dynamic) {
        if (!this.activation.isMatched()) {
            return;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((InternalFactHandle)dep.getJustified()).getObject())) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
        } else {
            FactHandle handle = this.workingMemory.insert(object, value, dynamic, true, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, handle);
            }
        }
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency dep;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                this.workingMemory.getTruthMaintenanceSystem().removeLogicalDependency(this.activation, dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                justified.getBlockers().remove(dep.getJustifierEntry());
                if (justified.getBlockers().isEmpty()) {
                    ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(justified);
                }
                dep = tmp;
            }
        }
    }

    public void cancelActivation(Activation act) {
        AgendaItem match = (AgendaItem)act;
        match.cancel();
        if (match.isActive()) {
            LeftTuple leftTuple = match.getTuple();
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, (PropagationContext)act.getPropagationContext(), this.workingMemory);
        }
    }

    public FactHandle lookupFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        return handle;
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public FactHandle getFactHandle(FactHandle handle) {
        Object object = ((InternalFactHandle)handle).getObject();
        if ((handle = this.getFactHandleFromWM(object)) == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, newObject, Long.MIN_VALUE, newObject.getClass(), this.activation);
        if (this.getIdentityMap() != null) {
            this.getIdentityMap().put(newObject, handle);
        }
    }

    @Override
    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    @Override
    public void update(FactHandle handle, long mask, Class<?> modifiedClass) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.activation);
        if (h.isTraitOrTraitable()) {
            Thing x;
            if (h.isTraitable()) {
                if (((TraitableBean)h.getObject()).hasTraits()) {
                    this.updateTraits(h.getObject(), mask, null, modifiedClass, null, ((TraitableBean)h.getObject()).getMostSpecificTraits());
                }
            } else if (h.isTraiting() && (x = (Thing)h.getObject()) != x.getCore()) {
                Object core = x.getCore();
                InternalFactHandle coreHandle = (InternalFactHandle)this.getFactHandle(core);
                ((InternalWorkingMemoryEntryPoint)coreHandle.getEntryPoint()).update(coreHandle, core, mask, modifiedClass, this.activation);
                BitSet veto = ((TraitProxy)((Object)x)).getTypeCode();
                this.updateTraits(core, mask, x, modifiedClass, veto, ((TraitableBean)core).getMostSpecificTraits());
            }
        }
    }

    private void updateTraits(Object object, long mask, Thing originator, Class<?> modifiedClass, BitSet veto, Collection<Thing> mostSpecificTraits) {
        this.updateManyTraits(object, mask, Arrays.asList(originator), modifiedClass, veto, mostSpecificTraits);
    }

    private void updateManyTraits(Object object, long mask, Collection<Thing> originators, Class<?> modifiedClass, BitSet veto, Collection<Thing> mostSpecificTraits) {
        veto = veto != null ? (BitSet)veto.clone() : null;
        for (Thing t : mostSpecificTraits) {
            if (originators.contains(t)) continue;
            TraitProxy proxy = (TraitProxy)((Object)t);
            proxy.setTypeFilter(veto);
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(t);
            if (h != null) {
                ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, t, mask, modifiedClass, this.activation);
            }
            proxy.setTypeFilter(null);
            BitSet tc = proxy.getTypeCode();
            if (veto == null) {
                veto = (BitSet)tc.clone();
                continue;
            }
            veto.or(tc);
        }
    }

    @Override
    public void update(Object object) {
        this.update(object, Long.MAX_VALUE, Object.class);
    }

    @Override
    public void update(Object object, long mask, Class<?> modifiedClass) {
        this.update(this.getFactHandle(object), mask, modifiedClass);
    }

    @Override
    public void retract(Object object) {
        this.retract(this.getFactHandle(object));
    }

    @Override
    public void retract(FactHandle handle) {
        Object o = ((InternalFactHandle)handle).getObject();
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).retract(handle, true, true, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().remove(o);
        }
    }

    @Override
    public Rule getRule() {
        return this.activation.getRule();
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public KnowledgeRuntime getKnowledgeRuntime() {
        return ((ReteooWorkingMemory)this.workingMemory).getKnowledgeRuntime();
    }

    @Override
    public org.drools.spi.Activation getActivation() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        InternalWorkingMemoryEntryPoint wmTmp = (InternalWorkingMemoryEntryPoint)this.tuple.get(declaration).getEntryPoint();
        if (wmTmp != null) {
            Object object = declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.get(declaration).getObject());
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, wmTmp.getFactHandleByIdentity(object));
            }
            return object;
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return ((AgendaItem)this.activation).getRuleTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoints().get(id);
    }

    @Override
    @Deprecated
    public ExitPoint getExitPoint(String id) {
        return this.workingMemory.getExitPoints().get(id);
    }

    @Override
    public Channel getChannel(String id) {
        return this.workingMemory.getChannels().get(id);
    }

    @Override
    public Map<String, WorkingMemoryEntryPoint> getEntryPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getEntryPoints());
    }

    @Override
    @Deprecated
    public Map<String, ExitPoint> getExitPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getExitPoints());
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.workingMemory.getChannels());
    }

    @Override
    public IdentityHashMap<Object, FactHandle> getIdentityMap() {
        return this.identityMap;
    }

    @Override
    public void setIdentityMap(IdentityHashMap<Object, FactHandle> identityMap) {
        this.identityMap = identityMap;
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        for (WorkingMemoryEntryPoint workingMemoryEntryPoint : this.workingMemory.getEntryPoints().values()) {
            handle = (FactHandle)workingMemoryEntryPoint.getFactHandle(object);
            if (this.identityMap != null) {
                this.identityMap.put(object, handle);
            }
            if (handle == null) continue;
            break;
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (org.drools.runtime.process.ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getActivation().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            ProcessContext context = new ProcessContext(this.workingMemory.getKnowledgeRuntime());
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            WorkflowProcessInstance container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)subNodeInstance;
                }
            }
            return (T)context;
        }
        return null;
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits) {
        return this.don(core, traits, false);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean logical) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(((Thing)core).getCore(), traits, logical);
        }
        if (traits.isEmpty()) {
            return (T)this.don(core, Thing.class, logical);
        }
        try {
            T thing = this.applyManyTraits(core, traits, null, logical);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(((Thing)core).getCore(), trait, logical);
        }
        try {
            T thing = this.applyTrait(core, trait, null, logical);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    protected <T> T doInsertTrait(T thing, Object core, boolean logical, BitSet boundary) {
        if (thing == core) {
            return thing;
        }
        ((TraitProxy)thing).setTypeFilter(boundary);
        if (logical) {
            this.insertLogical(thing);
        } else {
            this.insert(thing);
        }
        ((TraitProxy)thing).setTypeFilter(null);
        return thing;
    }

    protected <K> TraitableBean<K, CoreWrapper<K>> asTraitable(K core, TraitFactory builder) {
        ClassDefinition coreDef = this.lookupClassDefinition(core);
        if (core instanceof Map) {
            if (!coreDef.isTraitable()) {
                throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass() + ". Was it declared as @Traitable? ");
            }
            return coreDef.isFullTraiting() ? new LogicalMapCore((Map)core) : new MapCore((Map)core);
        }
        CoreWrapper<?> wrapper = builder.getCoreWrapper(core.getClass(), coreDef);
        if (wrapper == null) {
            throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass() + ". Was it declared as @Traitable? ");
        }
        wrapper.init(core);
        return wrapper;
    }

    protected <K> ClassDefinition lookupClassDefinition(K core) {
        TypeDeclaration decl;
        Package pack = this.getWorkingMemory().getRuleBase().getPackage(core.getClass().getPackage().getName());
        if (pack != null && (decl = pack.getTypeDeclaration(core.getClass())) != null) {
            return decl.getTypeClassDef();
        }
        return null;
    }

    protected <T, K> T applyManyTraits(K core, Collection<Class<? extends Thing>> traits, Object value, boolean logical) throws LogicalTypeInconsistencyException {
        TraitFactory builder = TraitFactory.getTraitBuilderForKnowledgeBase(this.getKnowledgeRuntime().getKnowledgeBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical);
        Collection<Thing> mostSpecificTraits = inner.getMostSpecificTraits();
        boolean newTraitsAdded = false;
        Thing firstThing = null;
        HashMap<Thing, BitSet> things = new HashMap<Thing, BitSet>(traits.size());
        for (Class<? extends Thing> trait : traits) {
            boolean needsUpdate;
            boolean needsProxy = trait.isAssignableFrom(inner.getClass());
            boolean hasTrait = inner.hasTrait(trait.getName());
            boolean bl = needsUpdate = needsProxy || core != inner;
            if (hasTrait) continue;
            BitSet boundary = inner.getCurrentTypeCode() != null ? (BitSet)inner.getCurrentTypeCode().clone() : null;
            Thing thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical);
            this.configureTrait(thing, value);
            things.put(thing, boundary);
            if (newTraitsAdded || trait == Thing.class) continue;
            firstThing = thing;
            newTraitsAdded = true;
        }
        for (Thing t : things.keySet()) {
            this.doInsertTrait(t, core, logical, (BitSet)things.get(t));
        }
        if (newTraitsAdded && mostSpecificTraits != null) {
            this.updateCore(inner, core, null, logical);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateManyTraits(inner, Long.MIN_VALUE, things.keySet(), core.getClass(), null, mostSpecificTraits);
            }
        }
        return (T)firstThing;
    }

    protected <T, K> T applyTrait(K core, Class<T> trait, Object value, boolean logical) throws LogicalTypeInconsistencyException {
        TraitFactory builder = TraitFactory.getTraitBuilderForKnowledgeBase(this.getKnowledgeRuntime().getKnowledgeBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical);
        boolean needsProxy = trait.isAssignableFrom(inner.getClass());
        boolean hasTrait = inner.hasTrait(trait.getName());
        boolean needsUpdate = needsProxy || core != inner;
        BitSet boundary = inner.getCurrentTypeCode() != null ? (BitSet)inner.getCurrentTypeCode().clone() : null;
        Collection<Thing> mostSpecificTraits = this.getTraitBoundary(inner, needsProxy, hasTrait, trait);
        T thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical);
        this.configureTrait(thing, value);
        thing = this.doInsertTrait(thing, core, logical, boundary);
        this.refresh(thing, core, inner, trait, mostSpecificTraits, logical);
        return thing;
    }

    protected Collection<Thing> getTraitBoundary(TraitableBean inner, boolean needsProxy, boolean hasTrait, Class trait) {
        boolean refresh;
        boolean bl = refresh = !needsProxy && !hasTrait && Thing.class != trait;
        if (refresh) {
            return inner.getMostSpecificTraits();
        }
        return null;
    }

    private <T, K> void refresh(T thing, K core, TraitableBean inner, Class<T> trait, Collection<Thing> mostSpecificTraits, boolean logical) {
        if (mostSpecificTraits != null) {
            this.updateCore(inner, core, trait, logical);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateTraits(inner, Long.MIN_VALUE, (Thing)thing, trait, null, mostSpecificTraits);
            }
        } else if (Thing.class == trait) {
            this.updateCore(inner, core, trait, logical);
        }
    }

    private <T> void updateCore(TraitableBean inner, Object core, Class<T> trait, boolean logical) {
        FactHandle handle = this.lookupFactHandle(inner);
        InternalFactHandle h = (InternalFactHandle)handle;
        if (handle != null) {
            TraitFieldTMS fieldTMS = inner._getFieldTMS();
            long mask = fieldTMS == null ? Long.MIN_VALUE : fieldTMS.getAndResetModificationMask();
            ((NamedEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, core.getClass(), this.activation);
        } else {
            handle = this.workingMemory.insert(inner, null, false, logical, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(inner, handle);
            }
        }
    }

    private <T, K> T asTrait(K core, TraitableBean inner, Class<T> trait, boolean needsProxy, boolean hasTrait, boolean needsUpdate, TraitFactory builder, boolean logical) throws LogicalTypeInconsistencyException {
        Thing<Object> thing;
        if (needsProxy) {
            thing = inner;
            inner.addTrait(trait.getName(), (Thing)core);
        } else {
            thing = hasTrait ? inner.getTrait(trait.getName()) : builder.getProxy(inner, trait, logical);
        }
        if (needsUpdate) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            if (h == null) {
                h = this.lookupHandleForWrapper(core);
            }
            if (h == null) {
                h = (InternalFactHandle)this.workingMemory.insert(core, null, false, logical, this.activation.getRule(), this.activation);
                if (this.identityMap != null) {
                    this.getIdentityMap().put(core, h);
                }
            }
            if (!h.isTraitOrTraitable()) {
                throw new IllegalStateException("A traited working memory element is being used with a default fact handle. Please verify that its class was declared as @Traitable : " + core.getClass().getName());
            }
            this.update(h, inner);
        }
        return (T)thing;
    }

    private <K> InternalFactHandle lookupHandleForWrapper(K core) {
        for (WorkingMemoryEntryPoint workingMemoryEntryPoint : this.workingMemory.getEntryPoints().values()) {
            ObjectStore store = ((InternalWorkingMemoryEntryPoint)workingMemoryEntryPoint).getObjectStore();
            Iterator iter = store.iterateFactHandles();
            while (iter.hasNext()) {
                InternalFactHandle handle = (InternalFactHandle)iter.next();
                if (!handle.isTraitable() || !(handle.getObject() instanceof CoreWrapper) || ((CoreWrapper)handle.getObject()).getCore() != core) continue;
                return handle;
            }
        }
        return null;
    }

    private <K> TraitableBean makeTraitable(K core, TraitFactory builder, boolean logical) {
        TraitableBean<K, CoreWrapper<K>> inner;
        boolean needsWrapping = !(core instanceof TraitableBean);
        TraitableBean<K, CoreWrapper<K>> traitableBean = inner = needsWrapping ? this.asTraitable(core, builder) : (TraitableBean<K, CoreWrapper<K>>)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            InternalWorkingMemoryEntryPoint ep = h != null ? (InternalWorkingMemoryEntryPoint)h.getEntryPoint() : (InternalWorkingMemoryEntryPoint)this.workingMemory.getEntryPoints().get("DEFAULT");
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
            if (inner._getFieldTMS() != null && inner._getFieldTMS().needsInit()) {
                inner._getFieldTMS().init(this.workingMemory);
            }
        } else {
            TraitFieldTMS ftms = inner._getFieldTMS();
            if (ftms != null) {
                FactHandle handle = this.lookupFactHandle(inner);
                if (handle == null) {
                    handle = this.workingMemory.insert(inner, null, false, logical, this.activation.getRule(), this.activation);
                    if (this.identityMap != null) {
                        this.getIdentityMap().put(inner, handle);
                    }
                }
                if (ftms.needsInit()) {
                    ftms.init(this.workingMemory);
                }
            }
        }
        return inner;
    }

    protected <T> void configureTrait(T thing, Object value) {
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical) {
        return this.don(core.getCore(), trait, logical);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    @Override
    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    @Override
    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
        Collection removedTypes;
        if (trait.isAssignableFrom(core.getClass())) {
            Collection removedTraits = core.removeTrait(trait.getName());
            if (!removedTraits.isEmpty()) {
                this.update(core, Long.MIN_VALUE, core.getClass());
            }
            return (Thing)((Object)core);
        }
        Thing thing = core.getTrait(Thing.class.getName());
        if (trait == Thing.class) {
            ArrayList removedTypes2 = new ArrayList(core._getTraitMap().values());
            for (Thing thing2 : removedTypes2) {
                if (((TraitType)((Object)thing2)).isVirtual()) continue;
                this.retract(thing2);
            }
            core._getTraitMap().clear();
            core._setTraitMap(null);
            return thing;
        }
        if (core.hasTrait(trait.getName())) {
            removedTypes = core.removeTrait(trait.getName());
        } else {
            HierarchyEncoder<String> hier = ((ReteooRuleBase)this.workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            BitSet bitSet = hier.getCode(trait.getName());
            removedTypes = core.removeTrait(bitSet);
        }
        removedTypes = new ArrayList(removedTypes);
        for (Thing thing3 : removedTypes) {
            if (((TraitType)((Object)thing3)).isVirtual()) continue;
            this.retract(thing3);
        }
        if (!core.hasTraits()) {
            this.don(core, Thing.class);
        } else if (!removedTypes.isEmpty()) {
            this.update(core, Long.MIN_VALUE, core.getClass());
        }
        return thing;
    }

    @Override
    public void modify(Object newObject) {
    }
}

