/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class IncludesEvaluatorDefinition
implements EvaluatorDefinition {
    public static final String includesOp = "includes";
    public static Operator INCLUDES;
    public static Operator INCLUDES_NOT;
    private static String[] SUPPORTED_IDS;
    private Map<String, IncludesEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public IncludesEvaluatorDefinition() {
        IncludesEvaluatorDefinition.init();
    }

    static void init() {
        if (Operator.determineOperator(includesOp, false) == null) {
            INCLUDES = Operator.addOperatorToRegistry(includesOp, false);
            INCLUDES_NOT = Operator.addOperatorToRegistry(includesOp, true);
            SUPPORTED_IDS = new String[]{includesOp};
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        IncludesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, IncludesEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new IncludesEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class IncludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long startMinDev;
        private long startMaxDev;
        private long endMinDev;
        private long endMaxDev;
        private String paramText;

        public IncludesEvaluator() {
            IncludesEvaluatorDefinition.init();
        }

        public IncludesEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? INCLUDES_NOT : INCLUDES);
            IncludesEvaluatorDefinition.init();
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startMinDev = in.readLong();
            this.startMaxDev = in.readLong();
            this.endMinDev = in.readLong();
            this.endMaxDev = in.readLong();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startMinDev);
            out.writeLong(this.startMaxDev);
            out.writeLong(this.endMinDev);
            out.writeLong(this.endMaxDev);
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'includes' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long distStart = ((EventFactHandle)left).getStartTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long distEnd = ((VariableRestriction.TemporalVariableContextEntry)context).endTS - ((EventFactHandle)left).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            long distStart = ((VariableRestriction.TemporalVariableContextEntry)context).startTS - ((EventFactHandle)right).getStartTimestamp();
            long distEnd = ((EventFactHandle)right).getEndTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            return this.getOperator().isNegated() ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            long distStart = ((EventFactHandle)handle2).getStartTimestamp() - ((EventFactHandle)handle1).getStartTimestamp();
            long distEnd = ((EventFactHandle)handle1).getEndTimestamp() - ((EventFactHandle)handle2).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
        }

        public String toString() {
            return "includes[" + this.startMinDev + ", " + this.startMaxDev + ", " + this.endMinDev + ", " + this.endMaxDev + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endMaxDev ^ this.endMaxDev >>> 32);
            result = 31 * result + (int)(this.endMinDev ^ this.endMinDev >>> 32);
            result = 31 * result + (int)(this.startMaxDev ^ this.startMaxDev >>> 32);
            result = 31 * result + (int)(this.startMinDev ^ this.startMinDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IncludesEvaluator other = (IncludesEvaluator)obj;
            return this.endMaxDev == other.endMaxDev && this.endMinDev == other.endMinDev && this.startMaxDev == other.startMaxDev && this.startMinDev == other.startMinDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startMinDev = 1L;
                this.startMaxDev = Long.MAX_VALUE;
                this.endMinDev = 1L;
                this.endMaxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.startMinDev = 1L;
                this.startMaxDev = parameters[0];
                this.endMinDev = 1L;
                this.endMaxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.startMinDev = parameters[0];
                this.startMaxDev = parameters[1];
                this.endMinDev = parameters[0];
                this.endMaxDev = parameters[1];
            } else if (parameters.length == 4) {
                this.startMinDev = parameters[0];
                this.startMaxDev = parameters[1];
                this.endMinDev = parameters[2];
                this.endMaxDev = parameters[3];
            } else {
                throw new RuntimeDroolsException("[During Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

