/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.base.DroolsQuery;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.JoinNodeLeftTuple;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.spi.PropagationContext;

public class JoinNode
extends BetaNode {
    private static final long serialVersionUID = 510L;

    public JoinNode() {
    }

    public JoinNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints binder, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, binder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.lrUnlinkingEnabled = context.getRuleBase().getConfiguration().isLRUnlinkingEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.lrUnlinkingEnabled && this.leftUnlinked(context, workingMemory, memory)) {
            return;
        }
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        if (useLeftMemory) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, context, it);
        while (rightTuple != null) {
            this.propagateFromLeft(rightTuple, leftTuple, contextEntry, useLeftMemory, context, workingMemory);
            rightTuple = (RightTuple)it.next(rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
    }

    protected void propagateFromLeft(RightTuple rightTuple, LeftTuple leftTuple, ContextEntry[] contextEntry, boolean useLeftMemory, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.constraints.isAllowedCachedLeft(contextEntry, handle)) {
            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, useLeftMemory);
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        if (this.lrUnlinkingEnabled && this.rightUnlinked(context, workingMemory, memory)) {
            context.getPropagationAttemptsMemory().add(this);
            return;
        }
        RightTuple rightTuple = this.createRightTuple(factHandle, this, context);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, it);
        while (leftTuple != null) {
            this.propagateFromRight(rightTuple, leftTuple, memory, context, workingMemory);
            leftTuple = (LeftTuple)it.next(leftTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    protected void propagateFromRight(RightTuple rightTuple, LeftTuple leftTuple, BetaMemory memory, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
        }
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.lrUnlinkingEnabled && memory.isRightUnlinked()) {
            return;
        }
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.firstChild != null) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.lrUnlinkingEnabled && memory.isLeftUnlinked()) {
            return;
        }
        memory.getLeftTupleMemory().remove(leftTuple);
        if (leftTuple.getFirstChild() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getRightTupleMemory().removeAdd(rightTuple);
        if (memory.getLeftTupleMemory() != null && memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, it);
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    this.propagateFromRight(rightTuple, leftTuple, memory, context, workingMemory);
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    childLeftTuple = this.propagateOrModifyFromRight(rightTuple, leftTuple, childLeftTuple, memory, context, workingMemory);
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            }
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    protected LeftTuple propagateOrModifyFromRight(RightTuple rightTuple, LeftTuple leftTuple, LeftTuple childLeftTuple, BetaMemory memory, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
            if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, childLeftTuple, context, workingMemory, true);
            } else {
                childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory, true);
            }
        } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
            childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory);
        }
        return childLeftTuple;
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ContextEntry[] contextEntry = memory.getContext();
        memory.getLeftTupleMemory().removeAdd(leftTuple);
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        LeftTuple childLeftTuple = leftTuple.getFirstChild();
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, context, it);
        if (childLeftTuple != null && rightMemory.isIndexed() && !it.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    this.propagateFromLeft(rightTuple, leftTuple, contextEntry, true, context, workingMemory);
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            } else {
                while (rightTuple != null) {
                    childLeftTuple = this.propagateOrModifyFromLeft(rightTuple, leftTuple, childLeftTuple, contextEntry, context, workingMemory);
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            }
        }
        this.constraints.resetTuple(contextEntry);
    }

    protected LeftTuple propagateOrModifyFromLeft(RightTuple rightTuple, LeftTuple leftTuple, LeftTuple childLeftTuple, ContextEntry[] contextEntry, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.constraints.isAllowedCachedLeft(contextEntry, handle)) {
            if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, childLeftTuple, null, context, workingMemory, true);
            } else {
                childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory, true);
            }
        } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
            childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory);
        }
        return childLeftTuple;
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        Memory m = workingMemory.getNodeMemory(this);
        BetaMemory memory = null;
        if (m instanceof BetaMemory) {
            memory = (BetaMemory)m;
        } else {
            workingMemory.getNodeMemory(this);
        }
        FastIterator it = memory.getLeftTupleMemory().fastIterator();
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle(), it);
            while (rightTuple != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) {
                    sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true), context, workingMemory);
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
            this.constraints.resetTuple(memory.getContext());
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.lrUnlinkingEnabled && memory.isLeftUnlinked()) {
            return;
        }
        super.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.lrUnlinkingEnabled && memory.isRightUnlinked()) {
            return;
        }
        super.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        return "[JoinNode(" + this.getId() + ") - " + this.getObjectTypeNode().getObjectType() + "]";
    }

    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new JoinNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }
}

