/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.RuleConditionElement;
import org.kie.api.definition.rule.Rule;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.PropertyTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELExprAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(MVELExprAnalyzer.class);

    /*
     * WARNING - void declaration
     */
    public static MVELAnalysisResult analyzeExpression(PackageBuildContext context, String expr, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes, String contextIdentifier, Class kcontextClass) {
        void var10_17;
        boolean bl;
        ParserContext parserContext2;
        HashMap variables;
        Class returnType;
        block24: {
            if (expr.trim().length() <= 0) {
                MVELAnalysisResult result = MVELExprAnalyzer.analyze(Collections.EMPTY_SET, availableIdentifiers);
                result.setMvelVariables(new HashMap());
                result.setTypesafe(true);
                return result;
            }
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            ParserConfiguration conf = context.getMVELDialectRuntimeData().getParserConfiguration();
            conf.setClassLoader(context.getKnowledgeBuilder().getRootClassLoader());
            ParserContext parserContext1 = new ParserContext(conf);
            if (localTypes != null) {
                for (Map.Entry<String, Class<?>> entry : localTypes.entrySet()) {
                    parserContext1.addInput(entry.getKey(), entry.getValue());
                }
            }
            if (availableIdentifiers.getThisClass() != null) {
                parserContext1.addInput("this", availableIdentifiers.getThisClass());
            }
            if (availableIdentifiers.getOperators() != null) {
                for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getOperators().entrySet()) {
                    parserContext1.addInput(entry.getKey(), ((EvaluatorWrapper)entry.getValue()).getClass());
                }
            }
            parserContext1.setStrictTypeEnforcement(false);
            parserContext1.setStrongTyping(false);
            parserContext1.setInterceptors(dialect.getInterceptors());
            try {
                returnType = MVEL.analyze((String)expr, (ParserContext)parserContext1);
            }
            catch (Exception exception) {
                BaseDescr base = context instanceof RuleBuildContext ? ((RuleBuildContext)context).getRuleDescr() : context.getParentDescr();
                DialectUtil.copyErrorLocation(exception, context.getParentDescr());
                context.addError(new DescrBuildError(base, context.getParentDescr(), null, "Unable to Analyse Expression " + expr + ":\n" + exception.getMessage()));
                return null;
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.addAll(parserContext1.getInputs().keySet());
            variables = parserContext1.getVariables();
            if (localTypes != null) {
                for (String string : localTypes.keySet()) {
                    variables.remove(string);
                }
            }
            if (availableIdentifiers.getThisClass() != null) {
                hashSet.removeIf(s -> PropertyTools.getFieldOrAccessor(availableIdentifiers.getThisClass(), (String)s) != null);
            }
            parserContext2 = new ParserContext(conf);
            parserContext2.setStrictTypeEnforcement(true);
            parserContext2.setStrongTyping(true);
            parserContext2.setInterceptors(dialect.getInterceptors());
            for (String input : hashSet) {
                if ("this".equals(input)) continue;
                Class<Object> cls = availableIdentifiers.resolveType(input);
                if (cls == null) {
                    if (input.equals(contextIdentifier) || input.equals("kcontext")) {
                        cls = kcontextClass;
                    } else if (input.equals("rule")) {
                        cls = Rule.class;
                    } else if (localTypes != null) {
                        cls = localTypes.get(input);
                    }
                }
                if (cls == null) continue;
                parserContext2.addInput(input, cls);
            }
            if (availableIdentifiers.getThisClass() != null) {
                parserContext2.addInput("this", availableIdentifiers.getThisClass());
            }
            boolean bl2 = context.isTypesafe();
            try {
                returnType = MVEL.analyze((String)expr, (ParserContext)parserContext2);
                bl = true;
            }
            catch (Exception e) {
                if (!bl2) break block24;
                BaseDescr base = context instanceof RuleBuildContext ? ((RuleBuildContext)context).getRuleDescr() : context.getParentDescr();
                DialectUtil.copyErrorLocation(e, context.getParentDescr());
                context.addError(new DescrBuildError(base, context.getParentDescr(), null, "Unable to Analyse Expression " + expr + ":\n" + e.getMessage()));
                return null;
            }
        }
        if (bl) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(parserContext2.getInputs().keySet());
            hashSet.addAll(variables.keySet());
            variables = parserContext2.getVariables();
            if (localTypes != null) {
                for (String str : localTypes.keySet()) {
                    variables.remove(str);
                }
            }
        }
        MVELAnalysisResult result = MVELExprAnalyzer.analyze((Set<String>)var10_17, availableIdentifiers);
        result.setReturnType(returnType);
        result.setMvelVariables(variables);
        result.setTypesafe(bl);
        return result;
    }

    private static MVELAnalysisResult analyze(Set<String> identifiers, BoundIdentifiers availableIdentifiers) {
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(identifiers);
        HashSet<String> notBound = new HashSet<String>(identifiers);
        notBound.remove("this");
        HashMap usedDecls = new HashMap();
        HashMap usedGlobals = new HashMap();
        HashMap<String, EvaluatorWrapper> usedOperators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getDeclrClasses().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedDecls.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (String string : identifiers) {
            Class<?> type = availableIdentifiers.resolveVarType(string);
            if (type == null) continue;
            usedGlobals.put(string, type);
            notBound.remove(string);
        }
        for (Map.Entry entry : availableIdentifiers.getOperators().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedOperators.put((String)entry.getKey(), (EvaluatorWrapper)entry.getValue());
            notBound.remove(entry.getKey());
        }
        BoundIdentifiers boundIdentifiers = new BoundIdentifiers(usedDecls, availableIdentifiers.getContext(), usedOperators, availableIdentifiers.getThisClass());
        boundIdentifiers.setGlobals(usedGlobals);
        result.setBoundIdentifiers(boundIdentifiers);
        result.setNotBoundedIdentifiers(notBound);
        return result;
    }

    public static Class<?> getExpressionType(PackageBuildContext context, Map<String, Class<?>> declCls, RuleConditionElement source, String expression) {
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
        ParserConfiguration conf = data.getParserConfiguration();
        conf.setClassLoader(context.getKnowledgeBuilder().getRootClassLoader());
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrongTyping(true);
        pctx.setStrictTypeEnforcement(true);
        for (Map.Entry<String, Class<?>> entry : declCls.entrySet()) {
            pctx.addInput(entry.getKey(), entry.getValue());
        }
        for (Declaration decl : source.getOuterDeclarations().values()) {
            pctx.addInput(decl.getBindingName(), decl.getDeclarationClass());
        }
        try {
            return MVEL.analyze((String)expression, (ParserContext)pctx);
        }
        catch (Exception e) {
            log.warn("Unable to parse expression: " + expression, (Throwable)e);
            return null;
        }
    }

    static {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
    }
}

