/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexClassFileInfo;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;

public class JandexClassFileServices
implements ClassFileServices {
    private IndexView index;
    private ComputingCache<DotName, Set<String>> annotationClassAnnotationsCache;
    private final ClassLoader classLoader;

    public JandexClassFileServices(JandexDiscoveryStrategy strategy) {
        this.index = strategy.getCompositeJandexIndex();
        if (this.index == null) {
            throw CommonLogger.LOG.jandexIndexNotCreated(ClassFileServices.class.getSimpleName());
        }
        this.classLoader = WeldResourceLoader.getClassLoader();
        this.annotationClassAnnotationsCache = ComputingCacheBuilder.newBuilder().build((Function)new AnnotationClassAnnotationLoader());
    }

    public ClassFileInfo getClassFileInfo(String className) {
        return new JandexClassFileInfo(className, this.index, this.annotationClassAnnotationsCache, this.classLoader);
    }

    public void cleanupAfterBoot() {
        if (this.annotationClassAnnotationsCache != null) {
            this.annotationClassAnnotationsCache.clear();
            this.annotationClassAnnotationsCache = null;
        }
        this.index = null;
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }

    private class AnnotationClassAnnotationLoader
    implements Function<DotName, Set<String>> {
        private AnnotationClassAnnotationLoader() {
        }

        public Set<String> apply(DotName name) {
            ClassInfo annotationClassInfo = JandexClassFileServices.this.index.getClassByName(name);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (annotationClassInfo != null) {
                for (DotName annotationName : annotationClassInfo.annotations().keySet()) {
                    builder.add((Object)annotationName.toString());
                }
            } else {
                try {
                    Class<?> annotationClass = JandexClassFileServices.this.classLoader.loadClass(name.toString());
                    for (Annotation annotation : annotationClass.getDeclaredAnnotations()) {
                        builder.add((Object)annotation.annotationType().getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw CommonLogger.LOG.unableToLoadAnnotation(name.toString());
                }
            }
            return builder.build();
        }
    }
}

