/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleFlowUploadWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowViewer;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;

public class RuleFlowWrapper
extends Composite
implements SaveEventListener,
EditorWidget {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private RuleViewer viewer;
    private Asset asset;
    private RuleFlowViewer ruleFlowViewer;
    private DecoratedDisclosurePanel parameterPanel;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public RuleFlowWrapper(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this.viewer = viewer;
        this.asset = asset;
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.initWidgets();
    }

    protected void initWidgets() {
        RuleFlowUploadWidget uploadWidget = new RuleFlowUploadWidget(this.asset, this.viewer, this.clientFactory, this.eventBus);
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)uploadWidget);
        if (ApplicationPreferences.showVisualRuleFlow()) {
            this.initRuleflowViewer();
            if (this.ruleFlowViewer != null && this.parameterPanel != null) {
                Button viewSource = new Button();
                viewSource.setText(this.constants.OpenEditorInNewWindow());
                viewSource.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent arg0) {
                        RuleFlowWrapper.this.doViewDiagram();
                        RuleFlowWrapper.this.ruleFlowViewer.update();
                    }
                });
                panel.add((Widget)viewSource);
            }
        }
        this.initWidget((Widget)panel);
        this.setStyleName(this.getOverallStyleName());
    }

    private void doViewDiagram() {
        LoadingPopup.showMessage(this.constants.CalculatingSource());
        try {
            Image image = new Image(images.viewSource());
            image.setAltText(ConstantsCore.INSTANCE.ViewSource());
            FormStylePopup pop = new FormStylePopup(image, this.constants.ViewingDiagram(), 800);
            pop.addRow((Widget)new ScrollPanel((Widget)this.ruleFlowViewer));
            pop.addRow((Widget)this.parameterPanel);
            pop.show();
        }
        catch (Exception e) {
            ErrorPopup.showMessage(this.constants.CouldNotCreateTheRuleflowDiagramItIsPossibleThatTheRuleflowFileIsInvalid());
        }
        LoadingPopup.close();
    }

    private void initRuleflowViewer() {
        RuleFlowContentModel rfcm = (RuleFlowContentModel)this.asset.getContent();
        if (rfcm != null && rfcm.getXml() != null && rfcm.getNodes() != null) {
            try {
                this.parameterPanel = new DecoratedDisclosurePanel(this.constants.Parameters());
                this.parameterPanel.ensureDebugId("cwDisclosurePanel");
                this.parameterPanel.setWidth("100%");
                this.parameterPanel.setOpen(false);
                FormStyleLayout parametersForm = new FormStyleLayout();
                parametersForm.setHeight("120px");
                this.parameterPanel.setContent((Widget)parametersForm);
                this.ruleFlowViewer = new RuleFlowViewer(rfcm, parametersForm);
            }
            catch (Exception e) {
                Window.alert((String)e.toString());
            }
        } else if (rfcm != null && rfcm.getXml() == null) {
            Window.alert((String)this.constants.CouldNotCreateTheRuleflowDiagramItIsPossibleThatTheRuleflowFileIsInvalid());
        }
    }

    public ImageResource getIcon() {
        return images.ruleflowLarge();
    }

    public String getOverallStyleName() {
        return "decision-Table-upload";
    }

    @Override
    public void onAfterSave() {
    }

    @Override
    public void onSave(SaveCommand saveCommand) {
        RuleFlowContentModel rfcm = (RuleFlowContentModel)this.asset.getContent();
        rfcm.setNodes(this.ruleFlowViewer.getTransferNodes());
        saveCommand.save();
    }

    public RuleFlowViewer getRuleFlowViewer() {
        return this.ruleFlowViewer;
    }
}

