/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.drools.guvnor.client.asseteditor.MultiViewRow;

public class MultiAssetPlace
extends Place {
    private final Collection<MultiViewRow> multiViewRows;

    public MultiAssetPlace(Collection<MultiViewRow> multiViewRows) {
        this.multiViewRows = multiViewRows;
    }

    public Collection<MultiViewRow> getMultiViewRows() {
        return this.multiViewRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MultiAssetPlace that = (MultiAssetPlace)((Object)o);
        if (this.multiViewRows != null) {
            Object[] thisObjects = this.multiViewRows.toArray();
            Object[] thatObjects = that.getMultiViewRows().toArray();
            Arrays.sort(thisObjects);
            Arrays.sort(thatObjects);
            if (!Arrays.equals(thisObjects, thatObjects)) {
                return false;
            }
        } else if (that.multiViewRows != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.multiViewRows != null) {
            Object[] thisObjects = this.multiViewRows.toArray();
            Arrays.sort(thisObjects);
            return Arrays.hashCode(thisObjects);
        }
        return 0;
    }

    public static class Tokenizer
    implements PlaceTokenizer<MultiAssetPlace> {
        public MultiAssetPlace getPlace(String token) {
            return new MultiAssetPlace(this.stripMultiViewRows(token));
        }

        public String getToken(MultiAssetPlace place) {
            String token = "";
            boolean first = true;
            for (MultiViewRow multiViewRow : place.getMultiViewRows()) {
                if (first) {
                    token = token + this.formMultiViewRowToken(multiViewRow);
                    first = false;
                    continue;
                }
                token = token + ",";
                token = token + this.formMultiViewRowToken(multiViewRow);
            }
            return token;
        }

        private String formMultiViewRowToken(MultiViewRow multiViewRow) {
            return "[" + multiViewRow.getUuid() + "|" + multiViewRow.getName() + "|" + multiViewRow.getFormat() + "]";
        }

        private List<MultiViewRow> stripMultiViewRows(String token) {
            ArrayList<MultiViewRow> rows = new ArrayList<MultiViewRow>();
            for (String multiRowToken : token.split(",")) {
                rows.add(this.stripRow(multiRowToken));
            }
            return rows;
        }

        private MultiViewRow stripRow(String multiRowToken) {
            String[] fields = multiRowToken.replace("[", "").replace("]", "").split("|");
            return new MultiViewRow(fields[0], fields[1], fields[2]);
        }
    }
}

