/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class StatusEditor
extends FormStylePopup {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private TextBox name = new TextBox();
    private Command refresh;

    public StatusEditor(Command refresh) {
        super(StatusEditor.getImage(), constants.CreateNewStatus());
        this.refresh = refresh;
        this.addAttribute(constants.StatusName(), (Widget)this.name);
        Button ok = new Button(constants.OK());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                StatusEditor.this.ok();
            }
        });
        this.addAttribute("", (Widget)ok);
    }

    private static Image getImage() {
        Image image = new Image(images.editCategory());
        image.setAltText(ConstantsCore.INSTANCE.EditCategory());
        return image;
    }

    void ok() {
        if ("".equals(this.name.getText())) {
            ErrorPopup.showMessage(constants.CanTHaveAnEmptyStatusName());
        } else {
            this.createStatus(this.name);
        }
    }

    private void createStatus(final TextBox box) {
        LoadingPopup.showMessage(constants.CreatingStatus());
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.createState(box.getText(), (AsyncCallback<String>)new GenericCallback<String>(){

            public void onSuccess(String data) {
                if (data != null) {
                    if (StatusEditor.this.refresh != null) {
                        box.setText("");
                        LoadingPopup.close();
                        StatusEditor.this.hide();
                        StatusEditor.this.refresh.execute();
                    }
                } else {
                    ErrorPopup.showMessage(constants.StatusWasNotSuccessfullyCreated());
                }
            }
        });
    }

    void cancel() {
        this.hide();
    }
}

