/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.perspective;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.explorer.navigation.NavigationPanel;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.perspective.PerspectivesPanelView;
import org.drools.guvnor.client.util.TabbedPanel;

public class PerspectivesPanelViewImpl
extends Composite
implements PerspectivesPanelView {
    private static PerspectivesPanelViewImplBinder uiBinder = (PerspectivesPanelViewImplBinder)GWT.create(PerspectivesPanelViewImplBinder.class);
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private PerspectivesPanelView.Presenter presenter;
    @UiField
    ListBox perspectives;
    @UiField
    SpanElement userName;
    @UiField
    HTMLPanel titlePanel;
    @UiField(provided=true)
    NavigationPanel navigationPanel;
    @UiField(provided=true)
    ExplorerViewCenterPanel explorerCenterPanel;
    @UiField
    Anchor logoutAnchor;

    public PerspectivesPanelViewImpl(ClientFactory clientFactory, EventBus eventBus) {
        this.navigationPanel = new NavigationPanel(clientFactory, eventBus);
        this.explorerCenterPanel = new ExplorerViewCenterPanel(clientFactory, eventBus);
        this.showTitle(this.canShowTitle());
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.titlePanel.setVisible(this.canShowTitle());
    }

    private boolean canShowTitle() {
        String parameter = Window.Location.getParameter((String)"nochrome");
        if (parameter == null) {
            return true;
        }
        return parameter.equals("true");
    }

    private void showTitle(boolean showTitle) {
        if (showTitle) {
            TitlePanelHeight.show();
        } else {
            TitlePanelHeight.hide();
        }
    }

    @Override
    public void setUserName(String userName) {
        this.userName.setInnerText(userName);
    }

    @Override
    public void addPerspective(String item, String value) {
        this.perspectives.addItem(item, value);
    }

    @Override
    public TabbedPanel getTabbedPanel() {
        return this.explorerCenterPanel;
    }

    @Override
    public void setPresenter(PerspectivesPanelView.Presenter presenter) {
        this.presenter = presenter;
    }

    @UiHandler(value={"perspectives"})
    public void handleChange(ChangeEvent event) {
        this.presenter.onChangePerspective(this.perspectives.getValue(this.perspectives.getSelectedIndex()));
    }

    @UiHandler(value={"logoutAnchor"})
    void logout(ClickEvent clickEvent) {
        this.presenter.onLogout();
    }

    public static class TitlePanelHeight {
        private static final int DEFAULT_HEIGHT = 4;
        private static int height = 4;

        public int getHeight() {
            return height;
        }

        public static void show() {
            height = 4;
        }

        public static void hide() {
            height = 0;
        }
    }

    static interface PerspectivesPanelViewImplBinder
    extends UiBinder<Widget, PerspectivesPanelViewImpl> {
    }
}

