/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.toolbar;

import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;

public class DefaultActionToolbarButtonsConfigurationProvider
implements ActionToolbarButtonsConfigurationProvider {
    public static String[] VALIDATING_FORMATS = new String[]{"brl", "dslr", "xls", "drl", "enumeration", "gdst", "model.drl", "dsl", "function", "template", "springContext", "serviceConfig", "scxls", "scgd"};
    private static String[] SOURCE_FORMATS = new String[]{"brl", "dslr", "drl", "model.drl", "xls", "gdst", "template", "bpmn2", "bpmn", "scxls", "scgd"};
    public static String[] VERIFY_FORMATS = new String[]{"brl", "xls", "drl", "gdst", "model.drl", "template"};
    private Asset asset;

    public DefaultActionToolbarButtonsConfigurationProvider(Asset asset) {
        this.asset = asset;
    }

    @Override
    public boolean showSaveButton() {
        return true;
    }

    @Override
    public boolean showSaveAndCloseButton() {
        return true;
    }

    @Override
    public boolean showCopyButton() {
        return true;
    }

    @Override
    public boolean showRenameButton() {
        return true;
    }

    @Override
    public boolean showPromoteToGlobalButton() {
        return true;
    }

    @Override
    public boolean showArchiveButton() {
        return this.asset.getVersionNumber() != 0L;
    }

    @Override
    public boolean showDeleteButton() {
        return this.asset.getVersionNumber() == 0L;
    }

    @Override
    public boolean showChangeStatusButton() {
        return true;
    }

    @Override
    public boolean showSelectWorkingSetsButton() {
        return "brl".equals(this.asset.getFormat()) || "template".equals(this.asset.getFormat());
    }

    @Override
    public boolean showValidateButton() {
        return this.isValidatorTypeAsset();
    }

    @Override
    public boolean showVerifyButton() {
        return this.isVerificationTypeAsset();
    }

    @Override
    public boolean showViewSourceButton() {
        return this.isMemberOfFormats(this.asset.getFormat(), SOURCE_FORMATS);
    }

    @Override
    public boolean showStateLabel() {
        return true;
    }

    private boolean isValidatorTypeAsset() {
        return this.isMemberOfFormats(this.asset.getFormat(), VALIDATING_FORMATS);
    }

    private boolean isVerificationTypeAsset() {
        return this.isMemberOfFormats(this.asset.getFormat(), VERIFY_FORMATS);
    }

    private boolean isMemberOfFormats(String format, String[] formats) {
        for (String fmt : formats) {
            if (!fmt.equals(format)) continue;
            return true;
        }
        return false;
    }
}

