/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.widgets.wizards.Wizard;
import org.drools.guvnor.client.widgets.wizards.WizardActivityView;
import org.drools.guvnor.client.widgets.wizards.WizardContext;
import org.drools.guvnor.client.widgets.wizards.WizardPage;
import org.drools.guvnor.client.widgets.wizards.WizardPageSelectedEvent;
import org.drools.guvnor.client.widgets.wizards.WizardPageStatusChangeEvent;
import org.drools.guvnor.client.widgets.wizards.WizardPlace;

public class WizardActivity
extends Activity
implements WizardActivityView.Presenter,
WizardPageStatusChangeEvent.Handler,
WizardPageSelectedEvent.Handler {
    private final WizardActivityView view;
    private final Wizard wizard;
    private final WizardContext context;

    public WizardActivity(WizardPlace<?> place, ClientFactory clientFactory) {
        this.context = place.getContext();
        this.view = clientFactory.getNavigationViewFactory().getWizardView(this.context);
        this.wizard = clientFactory.getWizardFactory().getWizard((WizardContext)place.getContext(), this);
        this.view.setPresenter(this);
    }

    @Override
    public void onStatusChange(WizardPageStatusChangeEvent event) {
        if (event.getSource() != this.context) {
            return;
        }
        for (WizardPage wp : this.wizard.getPages()) {
            int index = this.wizard.getPages().indexOf(wp);
            this.view.setPageCompletionState(index, wp.isComplete());
        }
        this.view.setCompletionStatus(this.wizard.isComplete());
    }

    @Override
    public void onPageSelected(WizardPageSelectedEvent event) {
        if (event.getSource() != this.context) {
            return;
        }
        WizardPage page = event.getSelectedPage();
        int index = this.wizard.getPages().indexOf(page);
        this.view.selectPage(index);
    }

    @Override
    public void start(AcceptItem acceptTabItem, EventBus eventBus) {
        eventBus.addHandler(WizardPageStatusChangeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(WizardPageSelectedEvent.TYPE, (EventHandler)this);
        this.view.setTitle(this.wizard.getTitle());
        this.view.setPreferredHeight(this.wizard.getPreferredHeight());
        this.view.setPreferredWidth(this.wizard.getPreferredWidth());
        this.view.setPageTitles(this.wizard.getPages());
        this.view.show();
        this.view.selectPage(0);
    }

    @Override
    public void pageSelected(int pageNumber) {
        Widget w = this.wizard.getPageWidget(pageNumber);
        this.view.setBodyWidget(w);
    }

    @Override
    public void complete() {
        this.wizard.complete();
    }

    @Override
    public void showSavingIndicator() {
        this.view.showSavingIndicator();
    }

    @Override
    public void hideSavingIndicator() {
        this.view.hideSavingIndicator();
    }

    @Override
    public void showDuplicateAssetNameError() {
        this.view.showDuplicateAssetNameError();
    }

    @Override
    public void showUnspecifiedCheckinError() {
        this.view.showUnspecifiedCheckinError();
    }

    @Override
    public void showCheckinError(String message) {
        this.view.showCheckinError(message);
    }

    @Override
    public void hide() {
        this.view.hide();
    }
}

