/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.ModuleFilter;
import org.drools.guvnor.server.builder.AssetItemValidator;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.builder.pagerow.ArchivedAssetPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.AssetPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QuickFindPageRowBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanRenderSource;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.AssetEditorConfiguration;
import org.drools.guvnor.server.util.AssetEditorConfigurationParser;
import org.drools.guvnor.server.util.AssetFormatHelper;
import org.drools.guvnor.server.util.AssetLockManager;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.MetaDataMapper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.VersionableItem;
import org.drools.repository.utils.AssetValidator;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;

@ApplicationScoped
public class RepositoryAssetOperations {
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetOperations.class);
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private Backchannel backchannel;
    @Inject
    private Identity identity;
    @Inject
    private Credentials credentials;
    @Inject
    private MailboxService mailboxService;
    @Inject
    private AssetLockManager assetLockManager;
    @Inject
    private AssetValidator assetValidator;
    private final String[] registeredFormats;

    public RepositoryAssetOperations() {
        AssetEditorConfigurationParser parser = new AssetEditorConfigurationParser();
        List<AssetEditorConfiguration> rfs = parser.getAssetEditors();
        this.registeredFormats = new String[rfs.size()];
        for (int i = 0; i < rfs.size(); ++i) {
            AssetEditorConfiguration config = rfs.get(i);
            this.registeredFormats[i] = config.getFormat();
        }
    }

    @Deprecated
    public void setRulesRepositoryForTest(RulesRepository repository) {
        this.rulesRepository = repository;
    }

    public String renameAsset(String uuid, String newName) {
        return this.rulesRepository.renameAsset(uuid, newName);
    }

    protected BuilderResult validateAsset(Asset asset) {
        try {
            ContentHandler handler = ContentManager.getHandler(asset.getFormat());
            AssetItem item = this.rulesRepository.loadAssetByUUID(asset.getUuid());
            handler.storeAssetContent(asset, item);
            AssetItemValidator assetItemValidator = new AssetItemValidator(handler, item);
            return assetItemValidator.validate();
        }
        catch (Exception e) {
            log.error("Unable to build asset.", e);
            BuilderResult result = new BuilderResult();
            result.addLine(this.createBuilderResultLine(asset));
            return result;
        }
    }

    private BuilderResultLine createBuilderResultLine(Asset asset) {
        BuilderResultLine builderResultLine = new BuilderResultLine();
        builderResultLine.setAssetName(asset.getName());
        builderResultLine.setAssetFormat(asset.getFormat());
        builderResultLine.setMessage("Unable to validate this asset. (Check log for detailed messages).");
        builderResultLine.setUuid(asset.getUuid());
        return builderResultLine;
    }

    public String checkinVersion(Asset asset) throws SerializationException {
        AssetItem repoAsset = this.rulesRepository.loadAssetByUUID(asset.getUuid());
        if (this.isAssetUpdatedInRepository(asset, repoAsset)) {
            return "ERR: Unable to save this asset, as it has been recently updated by [" + repoAsset.getLastContributor() + "]";
        }
        MetaData meta = asset.getMetaData();
        MetaDataMapper.getInstance().copyFromMetaData(meta, repoAsset);
        repoAsset.updateDateEffective(this.dateToCalendar(meta.getDateEffective()));
        repoAsset.updateDateExpired(this.dateToCalendar(meta.getDateExpired()));
        repoAsset.updateCategoryList(meta.getCategories());
        repoAsset.updateDescription(asset.getDescription());
        ContentHandler handler = ContentManager.getHandler(repoAsset.getFormat());
        handler.storeAssetContent(asset, repoAsset);
        repoAsset.updateValid(Boolean.valueOf(this.assetValidator.validate(repoAsset)));
        if (AssetFormats.affectsBinaryUpToDate(asset.getFormat())) {
            ModuleItem pkg = repoAsset.getModule();
            pkg.updateBinaryUpToDate(false);
            RuleBaseCache.getInstance().remove(pkg.getUUID());
        }
        repoAsset.checkin(asset.getCheckinComment());
        return repoAsset.getUUID();
    }

    private Calendar dateToCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private boolean isAssetUpdatedInRepository(Asset asset, AssetItem repoAsset) {
        return asset.getLastModified().before(repoAsset.getLastModified().getTime());
    }

    public void restoreVersion(String versionUUID, String assetUUID, String comment) {
        AssetItem old = this.rulesRepository.loadAssetByUUID(versionUUID);
        AssetItem head = this.rulesRepository.loadAssetByUUID(assetUUID);
        log.info("USER:" + this.getCurrentUserName() + " RESTORE of asset: [" + head.getName() + "] UUID: [" + head.getUUID() + "] with historical version number: [" + old.getVersionNumber());
        this.rulesRepository.restoreHistoricalAsset(old, head, comment);
    }

    protected TableDataResult loadItemHistory(VersionableItem item) {
        Iterator it = item.getHistory();
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        while (it.hasNext()) {
            VersionableItem historical = (VersionableItem)it.next();
            long versionNumber = historical.getVersionNumber();
            if (!this.isHistory(item, versionNumber)) continue;
            result.add(this.createHistoricalRow(historical));
        }
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        return table;
    }

    private boolean isHistory(VersionableItem item, long versionNumber) {
        return versionNumber != 0L;
    }

    private TableDataRow createHistoricalRow(VersionableItem historical) {
        DateFormat dateFormatter = DateFormat.getInstance();
        TableDataRow tableDataRow = new TableDataRow();
        tableDataRow.id = historical.getVersionSnapshotUUID();
        tableDataRow.values = new String[5];
        tableDataRow.values[0] = Long.toString(historical.getVersionNumber());
        tableDataRow.values[1] = historical.getCheckinComment();
        tableDataRow.values[2] = dateFormatter.format(historical.getLastModified().getTime());
        tableDataRow.values[3] = historical.getStateDescription();
        tableDataRow.values[4] = historical.getLastContributor();
        return tableDataRow;
    }

    protected TableDataResult loadArchivedAssets(int skip, int numRows) {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItemFilter filter = new AssetItemFilter(this.identity);
        AssetItemIterator it = this.rulesRepository.findArchivedAssets();
        it.skip((long)skip);
        int count = 0;
        while (it.hasNext()) {
            AssetItem archived = it.next();
            if (filter.accept(archived, "read")) {
                result.add(this.createArchivedRow(archived));
                ++count;
            }
            if (count != numRows) continue;
            break;
        }
        return this.createArchivedTable(result, it);
    }

    private TableDataRow createArchivedRow(AssetItem archived) {
        TableDataRow row = new TableDataRow();
        row.id = archived.getUUID();
        row.values = new String[5];
        row.values[0] = archived.getName();
        row.values[1] = archived.getFormat();
        row.values[2] = archived.getModuleName();
        row.values[3] = archived.getLastContributor();
        row.values[4] = Long.toString(archived.getLastModified().getTime().getTime());
        return row;
    }

    private TableDataResult createArchivedTable(List<TableDataRow> result, AssetItemIterator it) {
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        table.currentPosition = it.getPosition();
        table.total = it.getSize();
        table.hasNext = it.hasNext();
        return table;
    }

    protected PageResponse<AdminArchivedPageRow> loadArchivedAssets(PageRequest request) {
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.rulesRepository.findArchivedAssets();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        long totalRowsCount = iterator.getSize();
        List<AdminArchivedPageRow> rowList = new ArchivedAssetPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent((Iterator<AssetItem>)iterator).build();
        PageResponse<AdminArchivedPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!iterator.hasNext()).buildWithTotalRowCount(totalRowsCount);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Archived Assets in " + methodDuration + " ms.");
        return response;
    }

    protected TableDataResult listAssets(String packageUuid, String[] formats, int skip, int numRows, String tableConfig) {
        long start = System.currentTimeMillis();
        ModuleItem pkg = this.rulesRepository.loadModuleByUUID(packageUuid);
        AssetItemIterator it = formats.length > 0 ? pkg.listAssetsByFormat(formats) : pkg.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes());
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        log.debug("time for asset list load: " + (System.currentTimeMillis() - start));
        return handler.loadRuleListTable(it, skip, numRows);
    }

    protected TableDataResult quickFindAsset(String searchText, boolean searchArchived, int skip, int numRows) throws SerializationException {
        String search = searchText.replace('*', '%');
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        long start = System.currentTimeMillis();
        AssetItemIterator it = this.rulesRepository.findAssetsByName(search, searchArchived);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        AssetItemFilter filter = new AssetItemFilter(this.identity);
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!filter.accept(ai, RoleType.PACKAGE_READONLY.getName())) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    protected TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializationException {
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        ModuleFilter filter = new ModuleFilter(this.identity);
        AssetItemIterator assetItemIterator = this.rulesRepository.queryFullText(text, seekArchived);
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            Module data = new Module();
            data.setUuid(assetItem.getModule().getUUID());
            if (!filter.accept(data, RoleType.PACKAGE_READONLY.getName())) continue;
            resultList.add(assetItem);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    protected String buildAssetSource(Asset asset) throws SerializationException {
        ContentHandler handler = ContentManager.getHandler(asset.getFormat());
        StringBuilder stringBuilder = new StringBuilder();
        if (handler.isRuleAsset()) {
            BRMSPackageBuilder builder = new BRMSPackageBuilder();
            ModuleItem moduleItem = this.rulesRepository.loadModule(asset.getMetaData().getModuleName());
            builder.setDSLFiles(DSLLoader.loadDSLMappingFiles(moduleItem));
            if (asset.getMetaData().isBinary()) {
                AssetItem item = this.rulesRepository.loadAssetByUUID(asset.getUuid());
                handler.storeAssetContent(asset, item);
                ((IRuleAsset)((Object)handler)).assembleDRL(builder, item, stringBuilder);
            } else {
                ((IRuleAsset)((Object)handler)).assembleDRL(builder, asset, stringBuilder);
            }
        } else if (handler instanceof ICanRenderSource) {
            ICanRenderSource crs = (ICanRenderSource)((Object)handler);
            crs.assembleSource(asset.getContent(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    protected PageResponse<AssetPageRow> findAssetPage(AssetPageRequest request) {
        log.debug("Finding asset page of packageUuid (" + request.getPackageUuid() + ")");
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getAssetIterator(request);
        long totalRowsCount = iterator.getSize();
        List<AssetPageRow> rowList = new AssetPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(iterator).build();
        PageResponse<AssetPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!iterator.hasNext()).buildWithTotalRowCount(totalRowsCount);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Found asset page of packageUuid (" + request.getPackageUuid() + ") in " + methodDuration + " ms.");
        return response;
    }

    protected PageResponse<QueryPageRow> quickFindAsset(QueryPageRequest request) {
        String search = request.getSearchText().replace('*', '%');
        if (!search.startsWith("%")) {
            search = "%" + search;
        }
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.rulesRepository.findAssetsByName(search, request.isSearchArchived().booleanValue(), request.isCaseSensitive().booleanValue());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List<QueryPageRow> rowList = new QuickFindPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent((Iterator<AssetItem>)iterator).build();
        PageResponse<QueryPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!iterator.hasNext()).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Quick Find) for (" + search + ") in " + methodDuration + " ms.");
        return response;
    }

    protected void lockAsset(String uuid) {
        String userName = this.credentials.getUsername();
        log.info("Locking asset uuid=" + uuid + " for user [" + userName + "]");
        this.assetLockManager.lockAsset(uuid, userName);
    }

    protected void unLockAsset(String uuid) {
        log.info("Unlocking asset [" + uuid + "]");
        this.assetLockManager.unLockAsset(uuid);
    }

    protected String getAssetLockerUserName(String uuid) {
        String userName = this.assetLockManager.getAssetLockerUserName(uuid);
        log.info("Asset locked by [" + userName + "]");
        return userName;
    }

    protected Asset loadAsset(AssetItem item) throws SerializationException {
        Asset asset = new Asset();
        asset.setUuid(item.getUUID());
        asset.setName(item.getName());
        asset.setDescription(item.getDescription());
        asset.setLastModified(item.getLastModified().getTime());
        asset.setLastContributor(item.getLastContributor());
        asset.setState(item.getState() != null ? item.getState().getName() : "");
        asset.setDateCreated(item.getCreatedDate().getTime());
        asset.setCheckinComment(item.getCheckinComment());
        asset.setVersionNumber(item.getVersionNumber());
        asset.setFormat(item.getFormat());
        asset.setMetaData(this.populateMetaData(item));
        ContentHandler handler = ContentManager.getHandler(asset.getFormat());
        handler.retrieveAssetContent(asset, item);
        return asset;
    }

    MetaData populateMetaData(AssetItem item) {
        MetaData meta = this.populateMetaData((VersionableItem)item);
        meta.setModuleName(item.getModuleName());
        meta.setModuleUUID(item.getModule().getUUID());
        meta.setBinary(item.isBinary());
        List categories = item.getCategories();
        this.fillMetaCategories(meta, categories);
        meta.setDateEffective(this.calendarToDate(item.getDateEffective()));
        meta.setDateExpired(this.calendarToDate(item.getDateExpired()));
        return meta;
    }

    MetaData populateMetaData(VersionableItem item) {
        MetaData meta = new MetaData();
        MetaDataMapper.getInstance().copyToMetaData(meta, item);
        return meta;
    }

    private void fillMetaCategories(MetaData meta, List<CategoryItem> categories) {
        meta.setCategories(new String[categories.size()]);
        for (int i = 0; i < meta.getCategories().length; ++i) {
            CategoryItem cat = categories.get(i);
            meta.getCategories()[i] = cat.getFullPath();
        }
    }

    private Date calendarToDate(Calendar createdDate) {
        if (createdDate == null) {
            return null;
        }
        return createdDate.getTime();
    }

    protected void clearAllDiscussionsForAsset(String assetId) {
        RulesRepository repo = this.rulesRepository;
        AssetItem asset = repo.loadAssetByUUID(assetId);
        asset.updateStringProperty("", "discussion", false);
        repo.save();
        this.push("discussion", assetId);
    }

    protected List<DiscussionRecord> addToDiscussionForAsset(String assetId, String comment) {
        AssetItem asset = this.rulesRepository.loadAssetByUUID(assetId);
        Discussion dp = new Discussion();
        List<DiscussionRecord> discussion = dp.fromString(asset.getStringProperty("discussion"));
        discussion.add(new DiscussionRecord(this.rulesRepository.getSession().getUserID(), StringEscapeUtils.escapeXml((String)comment)));
        asset.updateStringProperty(dp.toString(discussion), "discussion", false);
        this.rulesRepository.save();
        this.push("discussion", assetId);
        this.mailboxService.recordItemUpdated(asset);
        return discussion;
    }

    protected long getAssetCount(AssetPageRequest request) {
        log.debug("Counting assets in packageUuid (" + request.getPackageUuid() + ")");
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getAssetIterator(request);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Counted assets in packageUuid (" + request.getPackageUuid() + ") in " + methodDuration + " ms.");
        return iterator.getSize();
    }

    private AssetItemIterator getAssetIterator(AssetPageRequest request) {
        AssetItemIterator iterator;
        ModuleItem packageItem = this.rulesRepository.loadModuleByUUID(request.getPackageUuid());
        if (request.getFormatInList() != null) {
            if (request.getFormatIsRegistered() != null) {
                throw new IllegalArgumentException("Combining formatInList and formatIsRegistered is not yet supported.");
            }
            iterator = packageItem.listAssetsByFormat(request.getFormatInList());
        } else {
            iterator = request.getFormatIsRegistered() != null && request.getFormatIsRegistered().equals(Boolean.FALSE) ? packageItem.listAssetsNotOfFormat(this.registeredFormats) : packageItem.queryAssets("");
        }
        return iterator;
    }

    private void push(String messageType, String message) {
        this.backchannel.publish(new PushResponse(messageType, message));
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }
}

