/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.repository.AssetItem;
import org.jboss.seam.security.Identity;

public class ArchivedAssetPageRowBuilder
implements PageRowBuilder<PageRequest, Iterator<AssetItem>> {
    private PageRequest pageRequest;
    private Iterator<AssetItem> iterator;
    private Identity identity;

    @Override
    public List<AdminArchivedPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        AssetItemFilter filter = new AssetItemFilter(this.identity);
        ArrayList<AdminArchivedPageRow> rowList = new ArrayList<AdminArchivedPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem archivedAssetItem = this.iterator.next();
            if (!filter.accept(archivedAssetItem, "read")) continue;
            if (skipped >= startRowIndex) {
                rowList.add(this.makeAdminArchivedPageRow(archivedAssetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    private AdminArchivedPageRow makeAdminArchivedPageRow(AssetItem assetItem) {
        AdminArchivedPageRow row = new AdminArchivedPageRow();
        row.setUuid(assetItem.getUUID());
        row.setFormat(assetItem.getFormat());
        row.setName(assetItem.getName());
        row.setPackageName(assetItem.getModuleName());
        row.setLastContributor(assetItem.getLastContributor());
        row.setLastModified(assetItem.getLastModified().getTime());
        return row;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public ArchivedAssetPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public ArchivedAssetPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public ArchivedAssetPageRowBuilder withContent(Iterator<AssetItem> iterator) {
        this.iterator = iterator;
        return this;
    }
}

