/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.FileManagerService;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.FormData;

public class AssetFileServlet
extends RepositoryServlet {
    private static final long serialVersionUID = 510L;
    @Inject
    private FileManagerService fileManagerService;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        FormData uploadItem = FileManagerService.getFormData(request);
        if (uploadItem.getFile() != null && uploadItem.getUuid() != null) {
            response.getWriter().write(this.processAttachFileToAsset(uploadItem));
            return;
        }
        response.getWriter().write("NO-SCRIPT-DATA");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uuid = req.getParameter("attachmentUUID");
        if (uuid != null) {
            this.processAttachmentDownload(uuid, res);
        } else {
            res.sendError(400);
        }
    }

    protected void processAttachmentDownload(String uuid, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String filename = this.fileManagerService.loadFileAttachmentByUUID(uuid, output);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ";");
        response.setContentLength(output.size());
        response.getOutputStream().write(output.toByteArray());
        response.getOutputStream().flush();
    }

    private String processAttachFileToAsset(FormData uploadItem) throws IOException {
        if ("".equals(uploadItem.getFile().getName())) {
            throw new IOException("No file selected.");
        }
        this.fileManagerService.attachFile(uploadItem);
        uploadItem.getFile().getInputStream().close();
        return "OK";
    }
}

