/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.VersionableItem;
import org.drools.verifier.doc.DroolsDocsBuilder;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

public class GuvnorDroolsDocsBuilder
extends DroolsDocsBuilder {
    private static final List<String> formats = new ArrayList<String>();

    private GuvnorDroolsDocsBuilder(ModuleItem packageItem) throws DroolsParserException {
        super(GuvnorDroolsDocsBuilder.createDrlPackageData(packageItem));
    }

    protected static DrlPackageParser createDrlPackageData(ModuleItem packageItem) {
        ArrayList<DrlRuleParser> rules = new ArrayList<DrlRuleParser>();
        Iterator assets = packageItem.getAssets();
        while (assets.hasNext()) {
            String drl;
            AssetItem assetItem = (AssetItem)assets.next();
            if (!formats.contains(assetItem.getFormat()) || assetItem.getDisabled() || assetItem.isArchived() || (drl = GuvnorDroolsDocsBuilder.getDRL(assetItem)) == null) continue;
            ArrayList<String> categories = new ArrayList<String>();
            for (CategoryItem categoryItem : assetItem.getCategories()) {
                categories.add(categoryItem.getName());
            }
            List ruleDataList = DrlRuleParser.findRulesDataFromDrl((String)drl);
            for (DrlRuleParser ruleData : ruleDataList) {
                ruleData.getOtherInformation().put("Categories", categories);
                ruleData.getMetadata().addAll(GuvnorDroolsDocsBuilder.createMetaData((VersionableItem)assetItem));
                rules.add(ruleData);
            }
        }
        String header = DroolsHeader.getDroolsHeader(packageItem);
        List globals = DrlPackageParser.findGlobals((String)header);
        return new DrlPackageParser(packageItem.getName(), packageItem.getDescription(), rules, globals, GuvnorDroolsDocsBuilder.createMetaData((VersionableItem)packageItem), new HashMap());
    }

    private static List<String> createMetaData(VersionableItem versionableItem) {
        ArrayList<String> list = new ArrayList<String>();
        Format formatter = GuvnorDroolsDocsBuilder.getFormatter();
        list.add("Creator :" + versionableItem.getCreator());
        list.add("Created date :" + formatter.format(versionableItem.getCreatedDate().getTime()));
        list.add("Last contributor :" + versionableItem.getLastContributor());
        list.add("Last modified :" + formatter.format(versionableItem.getLastModified().getTime()));
        list.add("Description :" + versionableItem.getDescription());
        return list;
    }

    public static GuvnorDroolsDocsBuilder getInstance(ModuleItem packageItem) throws DroolsParserException {
        return new GuvnorDroolsDocsBuilder(packageItem);
    }

    private static String getDRL(AssetItem item) {
        ContentHandler handler = ContentManager.getHandler(item.getFormat());
        if (!handler.isRuleAsset()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BRMSPackageBuilder builder = new BRMSPackageBuilder();
        builder.setDSLFiles(DSLLoader.loadDSLMappingFiles(item.getModule()));
        ((IRuleAsset)((Object)handler)).assembleDRL(builder, item, stringBuilder);
        return stringBuilder.toString();
    }

    static {
        formats.add("drl");
        formats.add("brl");
        formats.add("xls");
        formats.add("template");
        formats.add("gdst");
    }
}

