/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.maven.parser;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.drools.guvnor.client.rpc.MavenArtifact;

public class MavenDependencyTreeParser {
    public Pair<Collection<MavenArtifact>, Collection<MavenArtifact>> buildDependencyTreeAndList(String input) {
        Preconditions.checkNotNull((Object)input);
        return this.buildDependencyTreeAndList(new ByteArrayInputStream(input.getBytes()));
    }

    public Pair<Collection<MavenArtifact>, Collection<MavenArtifact>> buildDependencyTreeAndList(InputStream input) {
        Preconditions.checkNotNull((Object)input);
        try {
            return this.build(new BufferedReader(new InputStreamReader(input)));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read input stream.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse stream.", e);
        }
    }

    private Pair<Collection<MavenArtifact>, Collection<MavenArtifact>> build(BufferedReader buffer) throws Exception {
        ArrayList<MavenArtifact> dependencyTree = new ArrayList<MavenArtifact>();
        ArrayList<MavenArtifact> dependencyList = new ArrayList<MavenArtifact>();
        Stack<Pair<Integer, MavenArtifact>> stack = new Stack<Pair<Integer, MavenArtifact>>(){
            {
                this.push(new Pair<Integer, MavenArtifact>(Integer.MIN_VALUE, new MavenArtifact()));
            }
        };
        String strLine = null;
        block0: while ((strLine = buffer.readLine()) != null) {
            if (Character.isLetterOrDigit(strLine.charAt(0))) continue;
            for (int index = 0; index < strLine.length(); ++index) {
                if (!Character.isLetterOrDigit(strLine.charAt(index))) continue;
                String artifactDefinition = this.extractArtifactDefinition(strLine.substring(index));
                MavenArtifact newArtifact = new MavenArtifact(artifactDefinition);
                if (!newArtifact.isNecessaryOnRuntime()) continue block0;
                dependencyList.add(newArtifact);
                if (index == (Integer)((Pair)stack.peek()).getV1()) {
                    stack.pop();
                    ((MavenArtifact)((Pair)stack.peek()).getV2()).addChild(newArtifact);
                    stack.push(new Pair<Integer, MavenArtifact>(index, newArtifact));
                    continue block0;
                }
                if (index > (Integer)((Pair)stack.peek()).getV1()) {
                    ((MavenArtifact)((Pair)stack.peek()).getV2()).addChild(newArtifact);
                    stack.push(new Pair<Integer, MavenArtifact>(index, newArtifact));
                    continue block0;
                }
                while (index < (Integer)((Pair)stack.peek()).getV1()) {
                    stack.pop();
                }
                stack.pop();
                ((MavenArtifact)((Pair)stack.peek()).getV2()).addChild(newArtifact);
                stack.push(new Pair<Integer, MavenArtifact>(index, newArtifact));
                continue block0;
            }
        }
        while (stack.size() != 1) {
            stack.pop();
        }
        for (MavenArtifact artifact : ((MavenArtifact)((Pair)stack.peek()).getV2()).getChild()) {
            dependencyTree.add(artifact);
        }
        return new Pair<Collection<MavenArtifact>, Collection<MavenArtifact>>(dependencyTree, dependencyList);
    }

    private String extractArtifactDefinition(String content) {
        for (int index = 0; index < content.length(); ++index) {
            if (!Character.isSpaceChar(content.charAt(index))) continue;
            return content.substring(0, index);
        }
        return content;
    }

    public static class Pair<T1, T2> {
        private final T1 v1;
        private final T2 v2;

        Pair(T1 v1, T2 v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public T1 getV1() {
            return this.v1;
        }

        public T2 getV2() {
            return this.v2;
        }
    }
}

