/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.drools.guvnor.server.security.SecurityServiceImpl;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.jboss.resteasy.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ServerInterceptor
@ApplicationScoped
public class BasicAuthentication
implements PreProcessInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthentication.class);
    @Inject
    protected SecurityServiceImpl securityService;

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        if (request.getHttpHeaders().getRequestHeaders().containsKey((Object)"Authorization")) {
            String auth = (String)request.getHttpHeaders().getRequestHeader("Authorization").get(0);
            auth = StringUtils.substringAfter((String)auth, (String)"Basic");
            StringTokenizer tokenizer = null;
            try {
                auth = new String(Base64.decode((String)auth));
                tokenizer = new StringTokenizer(auth, ":");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse authorization string", e);
            }
            if (this.securityService.login(tokenizer.nextToken(), tokenizer.nextToken())) {
                return null;
            }
        }
        ServerResponse response = new ServerResponse();
        response.setStatus(401);
        Headers headers = new Headers();
        headers.add("Content-Type", (Object)"text/plain");
        headers.add("WWW-Authenticate", (Object)"BASIC realm=\"users\"");
        response.setMetadata((MultivaluedMap)headers);
        response.setEntity((Object)("Error 401 Unauthorized: " + request.getPreprocessedPath()));
        return response;
    }
}

