/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;

public class BuiltInSelector
implements AssetSelector {
    private String status;
    private String statusOperator;
    private String category;
    private String categoryOperator;
    private boolean enableStatusSelector;
    private boolean enableCategorySelector;
    private List<String> searchStatus;

    public boolean isEnableStatusSelector() {
        return this.enableStatusSelector;
    }

    public void setEnableStatusSelector(boolean enableStatusSelector) {
        this.enableStatusSelector = enableStatusSelector;
    }

    public boolean isEnableCategorySelector() {
        return this.enableCategorySelector;
    }

    public void setEnableCategorySelector(boolean enableCategorySelector) {
        this.enableCategorySelector = enableCategorySelector;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryOperator() {
        return this.categoryOperator;
    }

    public void setCategoryOperator(String categoryOperator) {
        this.categoryOperator = categoryOperator;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this.searchStatus = this.extractListFromComaSeparated(this.status);
    }

    public String getStatusOperator() {
        return this.statusOperator;
    }

    public void setStatusOperator(String statusOperator) {
        this.statusOperator = statusOperator;
    }

    @Override
    public boolean isAssetAllowed(AssetItem item) {
        if (this.enableStatusSelector && this.enableCategorySelector) {
            return this.isStatusAllowed(item) && this.isCategoryAllowed(item);
        }
        if (this.enableStatusSelector) {
            return this.isStatusAllowed(item);
        }
        if (this.enableCategorySelector) {
            return this.isCategoryAllowed(item);
        }
        return true;
    }

    private boolean isStatusAllowed(AssetItem item) {
        return "=".equals(this.statusOperator) ? this.searchStatus.contains(item.getStateDescription()) : "!=".equals(this.statusOperator) && !this.searchStatus.contains(item.getStateDescription());
    }

    public List<String> extractListFromComaSeparated(String status) {
        ArrayList<String> extractedList = new ArrayList<String>();
        if (status != null && status.length() > 0) {
            String newStatus;
            int firstIndex = 0;
            int lastIndex = status.indexOf(",", firstIndex);
            while (lastIndex != -1) {
                newStatus = status.substring(firstIndex, lastIndex);
                extractedList.add(newStatus);
                firstIndex = lastIndex + 1;
                lastIndex = status.indexOf(",", firstIndex);
            }
            if (firstIndex > 0) {
                newStatus = status.substring(firstIndex, status.length());
                extractedList.add(newStatus);
            } else {
                extractedList.add(status);
            }
        }
        return extractedList;
    }

    private boolean isCategoryAllowed(AssetItem item) {
        if ("=".equals(this.categoryOperator)) {
            for (CategoryItem cat : item.getCategories()) {
                if (!cat.getFullPath().equals(this.category)) continue;
                return true;
            }
        } else if ("!=".equals(this.categoryOperator)) {
            boolean categoryFound = false;
            for (CategoryItem cat : item.getCategories()) {
                if (!cat.getFullPath().equals(this.category)) continue;
                categoryFound = true;
            }
            return !categoryFound;
        }
        return false;
    }
}

