/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;

public class DroolsHeader {
    private static final String NL = System.getProperty("line.separator");
    private static final Pattern globalFinder = Pattern.compile("(^\\s*global.*?$)", 40);
    private static final Pattern importFinder = Pattern.compile("(^\\s*import.*?$)", 40);

    public static String getDroolsHeader(ModuleItem pkg) {
        if (pkg.containsAsset("drools")) {
            return pkg.loadAsset("drools").getContent();
        }
        return "";
    }

    public static void updateDroolsHeader(String string, ModuleItem pkg) {
        pkg.checkout();
        if (pkg.containsAsset("drools")) {
            AssetItem conf = pkg.loadAsset("drools");
            conf.updateContent(string);
            conf.checkin("");
        } else {
            AssetItem conf = pkg.addAsset("drools", "");
            conf.updateFormat("package");
            conf.updateContent(string);
            conf.checkin("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageHeaderImports(String packageHeader) {
        StringBuilder drl = new StringBuilder();
        Scanner scanner = new Scanner(packageHeader);
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!DroolsHeader.isImport(line)) continue;
                drl.append(line).append(NL);
            }
        }
        finally {
            scanner.close();
        }
        return drl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageHeaderGlobals(String packageHeader) {
        StringBuilder drl = new StringBuilder();
        Scanner scanner = new Scanner(packageHeader);
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!DroolsHeader.isGlobal(line)) continue;
                drl.append(line).append(NL);
            }
        }
        finally {
            scanner.close();
        }
        return drl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageHeaderMiscellaneous(String packageHeader) {
        StringBuilder drl = new StringBuilder();
        Scanner scanner = new Scanner(packageHeader);
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (DroolsHeader.isImport(line) || DroolsHeader.isGlobal(line)) continue;
                drl.append(line).append(NL);
            }
        }
        finally {
            scanner.close();
        }
        return drl.toString();
    }

    private static boolean isImport(String line) {
        Matcher gm = importFinder.matcher(line);
        return gm.find();
    }

    private static boolean isGlobal(String line) {
        Matcher gm = globalFinder.matcher(line);
        return gm.find();
    }
}

