/*
 * Decompiled with CFR 0.152.
 */
package org.gridcc.mce.mceworkflow.services;

import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLParser {
    private Document document = null;

    public String parseWSDL(String WSName, String uri) {
        String nodeString = "<node label='" + WSName + ":";
        String returnString = "";
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefination = reader.readWSDL(null, uri);
            String targetNamespace = wsdlDefination.getTargetNamespace();
            String targetNamespaceNode = "namespace='" + targetNamespace + "'>";
            String targetNamespaceAttribute = " namespace='" + targetNamespace + "'";
            Types types = wsdlDefination.getTypes();
            Map portTypesMap = wsdlDefination.getPortTypes();
            for (PortType portType : portTypesMap.values()) {
                String tempPortTypeString = nodeString + portType.getQName().getLocalPart() + "-(Port Type)' type='portType'" + targetNamespaceAttribute + ">";
                List operationsList = portType.getOperations();
                for (Operation operation : operationsList) {
                    String tempOperationString = nodeString + operation.getName() + "-(Operation)' type='operation'" + targetNamespaceAttribute + ">";
                    Input input = operation.getInput();
                    Message message = input.getMessage();
                    String tempInputMessageString = nodeString + message.getQName().getLocalPart() + "' type='inputMessage'" + targetNamespaceAttribute + "/>";
                    tempOperationString = tempOperationString + tempInputMessageString;
                    Output output = operation.getOutput();
                    message = output.getMessage();
                    String tempOutputMessageString = nodeString + message.getQName().getLocalPart() + "' type='inputMessage'" + targetNamespaceAttribute + "/>";
                    tempOperationString = tempOperationString + tempOutputMessageString;
                    tempOperationString = tempOperationString + "</node>";
                    tempPortTypeString = tempPortTypeString + tempOperationString;
                }
                tempPortTypeString = tempPortTypeString + "</node>";
                returnString = returnString + tempPortTypeString;
            }
            returnString = targetNamespaceNode + returnString;
            return returnString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "WSDL-Parsing-Exception";
        }
    }

    private void initiateDOM() {
        DocumentBuilderFactory DOMFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = DOMFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.document = builder.newDocument();
    }

    public void createRootElement(String root) {
        Element rootElement = this.document.createElement("node");
        rootElement.setAttribute("label", root);
        this.document.appendChild(rootElement);
    }

    public Element createPortType() {
        return null;
    }
}

