/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NikonType1MakernoteDescriptor
extends TagDescriptor<NikonType1MakernoteDirectory> {
    public NikonType1MakernoteDescriptor(@NotNull NikonType1MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 3: {
                return this.getQualityDescription();
            }
            case 4: {
                return this.getColorModeDescription();
            }
            case 5: {
                return this.getImageAdjustmentDescription();
            }
            case 6: {
                return this.getCcdSensitivityDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 8: {
                return this.getFocusDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getConverterDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getConverterDescription() {
        Integer value = ((NikonType1MakernoteDirectory)this._directory).getInteger(11);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Fisheye converter";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational value = ((NikonType1MakernoteDirectory)this._directory).getRational(10);
        if (value == null) {
            return null;
        }
        if (value.getNumerator() == 0L) {
            return "No digital zoom";
        }
        return value.toSimpleString(true) + "x digital zoom";
    }

    @Nullable
    public String getFocusDescription() {
        Rational value = ((NikonType1MakernoteDirectory)this._directory).getRational(8);
        if (value == null) {
            return null;
        }
        if (value.getNumerator() == 1L && value.getDenominator() == 0L) {
            return "Infinite";
        }
        return value.toSimpleString(true);
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((NikonType1MakernoteDirectory)this._directory).getInteger(7);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Preset";
            }
            case 2: {
                return "Daylight";
            }
            case 3: {
                return "Incandescence";
            }
            case 4: {
                return "Florescence";
            }
            case 5: {
                return "Cloudy";
            }
            case 6: {
                return "SpeedLight";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getCcdSensitivityDescription() {
        Integer value = ((NikonType1MakernoteDirectory)this._directory).getInteger(6);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "ISO80";
            }
            case 2: {
                return "ISO160";
            }
            case 4: {
                return "ISO320";
            }
            case 5: {
                return "ISO100";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getImageAdjustmentDescription() {
        Integer value = ((NikonType1MakernoteDirectory)this._directory).getInteger(5);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Bright +";
            }
            case 2: {
                return "Bright -";
            }
            case 3: {
                return "Contrast +";
            }
            case 4: {
                return "Contrast -";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getColorModeDescription() {
        Integer value = ((NikonType1MakernoteDirectory)this._directory).getInteger(4);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Color";
            }
            case 2: {
                return "Monochrome";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityDescription() {
        Integer value = ((NikonType1MakernoteDirectory)this._directory).getInteger(3);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "VGA Basic";
            }
            case 2: {
                return "VGA Normal";
            }
            case 3: {
                return "VGA Fine";
            }
            case 4: {
                return "SXGA Basic";
            }
            case 5: {
                return "SXGA Normal";
            }
            case 6: {
                return "SXGA Fine";
            }
        }
        return "Unknown (" + value + ")";
    }
}

