/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.base.version.VersionRecord;

public final class MetadataBuilder {
    private Path path;
    private Path realPath;
    private LockInfo lockInfo;
    private String checkinComment;
    private String lastContributor;
    private String creator;
    private Date lastModified;
    private Date dateCreated;
    private String subject;
    private String type;
    private String externalRelation;
    private String externalSource;
    private String description;
    private List<String> tags = new ArrayList<String>();
    private List<DiscussionRecord> discussion = new ArrayList<DiscussionRecord>();
    private List<VersionRecord> version = new ArrayList<VersionRecord>();
    private boolean generated;

    private MetadataBuilder() {
    }

    public static MetadataBuilder newMetadata() {
        return new MetadataBuilder();
    }

    public MetadataBuilder withPath(Path path) {
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this;
    }

    public MetadataBuilder withRealPath(Path realPath) {
        this.realPath = (Path)PortablePreconditions.checkNotNull((String)"realPath", (Object)realPath);
        return this;
    }

    public MetadataBuilder withCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
        return this;
    }

    public MetadataBuilder withLastContributor(String lastContributor) {
        this.lastContributor = lastContributor;
        return this;
    }

    public MetadataBuilder withCreator(String creator) {
        this.creator = PortablePreconditions.checkNotEmpty((String)"creator", (String)creator);
        return this;
    }

    public MetadataBuilder withLastModified(Date date) {
        this.lastModified = (Date)PortablePreconditions.checkNotNull((String)"date", (Object)date);
        return this;
    }

    public MetadataBuilder withDateCreated(Date date) {
        this.dateCreated = (Date)PortablePreconditions.checkNotNull((String)"date", (Object)date);
        return this;
    }

    public MetadataBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public MetadataBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public MetadataBuilder withExternalRelation(String externalRelation) {
        this.externalRelation = externalRelation;
        return this;
    }

    public MetadataBuilder withExternalSource(String externalSource) {
        this.externalSource = externalSource;
        return this;
    }

    public MetadataBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public MetadataBuilder withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetadataBuilder withDiscussion(List<DiscussionRecord> discussion) {
        this.discussion = discussion;
        return this;
    }

    public MetadataBuilder withVersion(List<VersionRecord> version) {
        this.version = version;
        return this;
    }

    public MetadataBuilder withLockInfo(LockInfo lockInfo) {
        this.lockInfo = lockInfo;
        return this;
    }

    public MetadataBuilder withGenerated(boolean generated) {
        this.generated = generated;
        return this;
    }

    public Metadata build() {
        return new Metadata(this.path, this.realPath, this.checkinComment, this.lastContributor, this.creator, this.lastModified, this.dateCreated, this.subject, this.type, this.externalRelation, this.externalSource, this.description, this.tags, this.discussion, this.version, this.lockInfo, this.generated);
    }
}

