/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.database;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.dictionary.database.Query;

public class ConnectionManager {
    private String _driverClass;
    private String _url;
    private String _userName;
    private String _password;
    private boolean _registered;

    public ConnectionManager(String driverClass, String url, String userName, String password) {
        this._driverClass = driverClass;
        this._url = url;
        this._userName = userName;
        this._password = password;
    }

    public Query getQuery(String sql) throws SQLException, JWNLException {
        return new Query(sql, this.getConnection());
    }

    public Connection getConnection() throws SQLException, JWNLException {
        this.registerDriver();
        if (this._userName == null) {
            return DriverManager.getConnection(this._url);
        }
        return DriverManager.getConnection(this._url, this._userName, this._password != null ? this._password : "");
    }

    private void registerDriver() throws JWNLException {
        if (!this._registered) {
            try {
                Driver driver = (Driver)Class.forName(this._driverClass).newInstance();
                DriverManager.registerDriver(driver);
                this._registered = true;
            }
            catch (Exception ex) {
                throw new JWNLException("DICTIONARY_EXCEPTION_024", ex);
            }
        }
    }
}

