/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.isatab;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class ISATabUtils {
    private static final ServiceLoader LOADER = new ServiceLoader(ISATabUtils.class.getClassLoader());
    private static final String[] sections = new String[]{"ONTOLOGY SOURCE REFERENCE", "INVESTIGATION", "INVESTIGATION PUBLICATIONS", "INVESTIGATION CONTACTS"};
    private static final String studySectionField = "STUDY";
    private static final String studyFileNameField = "Study File Name";

    public static void parseInvestigation(InputStream stream, XHTMLContentHandler handler, Metadata metadata, ParseContext context, String studyFileName) throws IOException, TikaException, SAXException {
        try (AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream(stream), metadata, (ServiceLoader)context.get(ServiceLoader.class, (Object)LOADER));){
            ISATabUtils.extractMetadata((Reader)reader, metadata, studyFileName);
        }
    }

    public static void parseInvestigation(InputStream stream, XHTMLContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        ISATabUtils.parseInvestigation(stream, handler, metadata, context, null);
    }

    public static void parseStudy(InputStream stream, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        TikaInputStream tis = TikaInputStream.get((InputStream)stream);
        try (AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream((InputStream)tis), metadata, (ServiceLoader)context.get(ServiceLoader.class, (Object)LOADER));
             CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.TDF);){
            CSVRecord record;
            Iterator iterator = csvParser.iterator();
            xhtml.startElement("table");
            xhtml.startElement("thead");
            if (iterator.hasNext()) {
                record = (CSVRecord)iterator.next();
                for (int i = 0; i < record.size(); ++i) {
                    xhtml.startElement("th");
                    xhtml.characters(record.get(i));
                    xhtml.endElement("th");
                }
            }
            xhtml.endElement("thead");
            xhtml.startElement("tbody");
            while (iterator.hasNext()) {
                record = (CSVRecord)iterator.next();
                xhtml.startElement("tr");
                for (int j = 0; j < record.size(); ++j) {
                    xhtml.startElement("td");
                    xhtml.characters(record.get(j));
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
        }
    }

    public static void parseAssay(InputStream stream, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        TikaInputStream tis = TikaInputStream.get((InputStream)stream);
        try (AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream((InputStream)tis), metadata, (ServiceLoader)context.get(ServiceLoader.class, (Object)LOADER));
             CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.TDF);){
            CSVRecord record;
            xhtml.startElement("table");
            Iterator iterator = csvParser.iterator();
            xhtml.startElement("thead");
            if (iterator.hasNext()) {
                record = (CSVRecord)iterator.next();
                for (int i = 0; i < record.size(); ++i) {
                    xhtml.startElement("th");
                    xhtml.characters(record.get(i));
                    xhtml.endElement("th");
                }
            }
            xhtml.endElement("thead");
            xhtml.startElement("tbody");
            while (iterator.hasNext()) {
                record = (CSVRecord)iterator.next();
                xhtml.startElement("tr");
                for (int j = 0; j < record.size(); ++j) {
                    xhtml.startElement("td");
                    xhtml.characters(record.get(j));
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
        }
    }

    private static void extractMetadata(Reader reader, Metadata metadata, String studyFileName) throws IOException {
        boolean investigationSection = false;
        boolean studySection = false;
        boolean studyTarget = false;
        HashMap<String, String> map = new HashMap<String, String>();
        try (CSVParser csvParser = new CSVParser(reader, CSVFormat.TDF);){
            for (CSVRecord record : csvParser) {
                String field = record.get(0);
                if (field.toUpperCase(Locale.ENGLISH).equals(field) && record.size() == 1) {
                    investigationSection = Arrays.asList(sections).contains(field);
                    studySection = studyFileName != null && field.equals(studySectionField);
                    continue;
                }
                if (investigationSection) {
                    ISATabUtils.addMetadata(field, record, metadata);
                    continue;
                }
                if (studySection) {
                    if (studyTarget) {
                        break;
                    }
                    String value = record.get(1);
                    map.put(field, value);
                    studyTarget = field.equals(studyFileNameField) && value.equals(studyFileName);
                    if (!studyTarget) continue;
                    ISATabUtils.mapStudyToMetadata(map, metadata);
                    studySection = false;
                    continue;
                }
                if (!studyTarget) continue;
                ISATabUtils.addMetadata(field, record, metadata);
            }
        }
    }

    private static void addMetadata(String field, CSVRecord record, Metadata metadata) {
        if (record == null || record.size() <= 1) {
            return;
        }
        for (int i = 1; i < record.size(); ++i) {
            metadata.add(field, record.get(i));
        }
    }

    private static void mapStudyToMetadata(Map<String, String> map, Metadata metadata) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            metadata.add(entry.getKey(), entry.getValue());
        }
    }
}

