/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFOldDocument;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.extractor.Word6Extractor;
import org.apache.poi.hwpf.model.FieldsDocumentPart;
import org.apache.poi.hwpf.model.PicturesTable;
import org.apache.poi.hwpf.model.SavedByEntry;
import org.apache.poi.hwpf.model.SavedByTable;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Field;
import org.apache.poi.hwpf.usermodel.HeaderStories;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.ListManager;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WordExtractor
extends AbstractPOIFSExtractor {
    private static final char UNICODECHAR_NONBREAKING_HYPHEN = '\u2011';
    private static final char UNICODECHAR_ZERO_WIDTH_SPACE = '\u200b';
    private static final String LIST_DELIMITER = " ";
    private static final Map<String, TagAndStyle> fixedParagraphStyles = new HashMap<String, TagAndStyle>();
    private static final TagAndStyle defaultParagraphStyle = new TagAndStyle("p", null);
    private boolean curStrikeThrough;
    private boolean curBold;
    private boolean curItalic;
    private final Metadata metadata;

    public WordExtractor(ParseContext context, Metadata metadata) {
        super(context);
        this.metadata = metadata;
    }

    private static int countParagraphs(Range ... ranges) {
        int count = 0;
        for (Range r : ranges) {
            if (r == null) continue;
            count += r.numParagraphs();
        }
        return count;
    }

    public static TagAndStyle buildParagraphTagAndStyle(String styleName, boolean isTable) {
        TagAndStyle tagAndStyle = fixedParagraphStyles.get(styleName);
        if (tagAndStyle != null) {
            return tagAndStyle;
        }
        if (styleName.equals("Table Contents") && isTable) {
            return defaultParagraphStyle;
        }
        String tag = "p";
        String styleClass = null;
        if (styleName.startsWith("heading") || styleName.startsWith("Heading")) {
            int num = 1;
            try {
                num = Integer.parseInt(styleName.substring(styleName.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            tag = "h" + Math.min(num, 6);
        } else {
            styleClass = styleName.replace(' ', '_');
            styleClass = styleClass.substring(0, 1).toLowerCase(Locale.ROOT) + styleClass.substring(1);
        }
        return new TagAndStyle(tag, styleClass);
    }

    protected void parse(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HWPFDocument document;
        try {
            document = new HWPFDocument(root);
        }
        catch (OldWordFileFormatException e) {
            this.parseWord6(root, xhtml);
            return;
        }
        this.extractSavedByMetadata(document);
        org.apache.poi.hwpf.extractor.WordExtractor wordExtractor = new org.apache.poi.hwpf.extractor.WordExtractor(document);
        HeaderStories headerFooter = new HeaderStories(document);
        PicturesTable pictureTable = document.getPicturesTable();
        PicturesSource pictures = new PicturesSource(document);
        Range[] headers = new Range[]{headerFooter.getFirstHeaderSubrange(), headerFooter.getEvenHeaderSubrange(), headerFooter.getOddHeaderSubrange()};
        this.handleHeaderFooter(headers, "header", document, pictures, pictureTable, xhtml);
        Range r = document.getRange();
        ListManager listManager = new ListManager(document);
        for (int i = 0; i < r.numParagraphs(); ++i) {
            Paragraph p = r.getParagraph(i);
            i += this.handleParagraph(p, 0, r, document, FieldsDocumentPart.MAIN, pictures, pictureTable, listManager, xhtml);
        }
        for (String paragraph : wordExtractor.getMainTextboxText()) {
            xhtml.element("p", paragraph);
        }
        for (String paragraph : wordExtractor.getFootnoteText()) {
            xhtml.element("p", paragraph);
        }
        for (String paragraph : wordExtractor.getCommentsText()) {
            xhtml.element("p", paragraph);
        }
        for (String paragraph : wordExtractor.getEndnoteText()) {
            xhtml.element("p", paragraph);
        }
        Range[] footers = new Range[]{headerFooter.getFirstFooterSubrange(), headerFooter.getEvenFooterSubrange(), headerFooter.getOddFooterSubrange()};
        this.handleHeaderFooter(footers, "footer", document, pictures, pictureTable, xhtml);
        Picture p = pictures.nextUnclaimed();
        while (p != null) {
            this.handlePictureCharacterRun(null, p, pictures, xhtml);
            p = pictures.nextUnclaimed();
        }
        try {
            DirectoryEntry op = (DirectoryEntry)root.getEntry("ObjectPool");
            for (Entry entry : op) {
                if (!entry.getName().startsWith("_") || !(entry instanceof DirectoryEntry)) continue;
                this.handleEmbeddedOfficeDoc((DirectoryEntry)entry, xhtml);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void extractSavedByMetadata(HWPFDocument document) {
        SavedByTable savedByTable = document.getSavedByTable();
        if (savedByTable == null) {
            return;
        }
        for (SavedByEntry sbe : savedByTable.getEntries()) {
            this.metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, sbe.getSaveLocation());
        }
    }

    private void handleHeaderFooter(Range[] ranges, String type, HWPFDocument document, PicturesSource pictures, PicturesTable pictureTable, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        if (WordExtractor.countParagraphs(ranges) > 0) {
            xhtml.startElement("div", "class", type);
            ListManager listManager = new ListManager(document);
            for (Range r : ranges) {
                if (r == null) continue;
                for (int i = 0; i < r.numParagraphs(); ++i) {
                    Paragraph p = r.getParagraph(i);
                    i += this.handleParagraph(p, 0, r, document, FieldsDocumentPart.HEADER, pictures, pictureTable, listManager, xhtml);
                }
            }
            xhtml.endElement("div");
        }
    }

    private int handleParagraph(Paragraph p, int parentTableLevel, Range r, HWPFDocument document, FieldsDocumentPart docPart, PicturesSource pictures, PicturesTable pictureTable, ListManager listManager, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        TagAndStyle tas;
        if (p.isInTable() && p.getTableLevel() > parentTableLevel && parentTableLevel == 0) {
            Table t = r.getTable(p);
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            for (int rn = 0; rn < t.numRows(); ++rn) {
                TableRow row = t.getRow(rn);
                xhtml.startElement("tr");
                for (int cn = 0; cn < row.numCells(); ++cn) {
                    TableCell cell = row.getCell(cn);
                    xhtml.startElement("td");
                    for (int pn = 0; pn < cell.numParagraphs(); ++pn) {
                        Paragraph cellP = cell.getParagraph(pn);
                        this.handleParagraph(cellP, p.getTableLevel(), (Range)cell, document, docPart, pictures, pictureTable, listManager, xhtml);
                    }
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            return t.numParagraphs() - 1;
        }
        String text = p.text();
        if (text.replaceAll("[\\r\\n\\s]+", "").isEmpty()) {
            return 0;
        }
        String numbering = null;
        if (document.getStyleSheet().numStyles() > p.getStyleIndex()) {
            StyleDescription style = document.getStyleSheet().getStyleDescription((int)p.getStyleIndex());
            if (style != null && style.getName() != null && style.getName().length() > 0) {
                if (p.isInList()) {
                    numbering = listManager.getFormattedNumber(p);
                }
                tas = WordExtractor.buildParagraphTagAndStyle(style.getName(), parentTableLevel > 0);
            } else {
                tas = new TagAndStyle("p", null);
            }
        } else {
            tas = new TagAndStyle("p", null);
        }
        if (tas.getStyleClass() != null) {
            xhtml.startElement(tas.getTag(), "class", tas.getStyleClass());
        } else {
            xhtml.startElement(tas.getTag());
        }
        if (numbering != null) {
            xhtml.characters(numbering);
        }
        for (int j = 0; j < p.numCharacterRuns(); ++j) {
            Field field;
            CharacterRun cr = p.getCharacterRun(j);
            if (cr.text().getBytes(StandardCharsets.UTF_8)[0] == 19 && (field = document.getFields().getFieldByStartOffset(docPart, cr.getStartOffset())) != null && (field.getType() == 58 || field.getType() == 56)) {
                String id = "_unknown_id";
                CharacterRun mscr = field.getMarkSeparatorCharacterRun(r);
                if (mscr != null) {
                    id = "_" + mscr.getPicOffset();
                }
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("", "id", "id", "CDATA", id);
                xhtml.startElement("div", attributes);
                xhtml.endElement("div");
            }
            if (cr.text().equals("\u0013")) {
                j += this.handleSpecialCharacterRuns(p, j, tas.isHeading(), pictures, xhtml);
                continue;
            }
            if (cr.text().startsWith("\b")) {
                for (int pn = 0; pn < cr.text().length(); ++pn) {
                    Picture picture = pictures.nextUnclaimed();
                    this.handlePictureCharacterRun(cr, picture, pictures, xhtml);
                }
                continue;
            }
            if (pictureTable.hasPicture(cr)) {
                Picture picture = pictures.getFor(cr);
                this.handlePictureCharacterRun(cr, picture, pictures, xhtml);
                continue;
            }
            this.handleCharacterRun(cr, tas.isHeading(), xhtml);
        }
        if (this.curStrikeThrough) {
            xhtml.endElement("s");
            this.curStrikeThrough = false;
        }
        if (this.curItalic) {
            xhtml.endElement("i");
            this.curItalic = false;
        }
        if (this.curBold) {
            xhtml.endElement("b");
            this.curBold = false;
        }
        xhtml.endElement(tas.getTag());
        return 0;
    }

    private void handleCharacterRun(CharacterRun cr, boolean skipStyling, XHTMLContentHandler xhtml) throws SAXException {
        if (!this.isRendered(cr) || cr.text().equals("\r")) {
            return;
        }
        if (!skipStyling) {
            if (cr.isBold() != this.curBold) {
                if (this.curStrikeThrough) {
                    xhtml.endElement("s");
                    this.curStrikeThrough = false;
                }
                if (this.curItalic) {
                    xhtml.endElement("i");
                    this.curItalic = false;
                }
                if (cr.isBold()) {
                    xhtml.startElement("b");
                } else {
                    xhtml.endElement("b");
                }
                this.curBold = cr.isBold();
            }
            if (cr.isItalic() != this.curItalic) {
                if (this.curStrikeThrough) {
                    xhtml.endElement("s");
                    this.curStrikeThrough = false;
                }
                if (cr.isItalic()) {
                    xhtml.startElement("i");
                } else {
                    xhtml.endElement("i");
                }
                this.curItalic = cr.isItalic();
            }
            if (cr.isStrikeThrough() != this.curStrikeThrough) {
                if (cr.isStrikeThrough()) {
                    xhtml.startElement("s");
                } else {
                    xhtml.endElement("s");
                }
                this.curStrikeThrough = cr.isStrikeThrough();
            }
        }
        String text = cr.text();
        if ((text = text.replace('\r', '\n')).endsWith("\u0007")) {
            text = text.substring(0, text.length() - 1);
        }
        text = text.replace('\u001e', '\u2011');
        text = text.replace('\u001f', '\u200b');
        text = text.replaceAll("[\u0000-\u001f]", "\n");
        xhtml.characters(text);
    }

    private int handleSpecialCharacterRuns(Paragraph p, int index, boolean skipStyling, PicturesSource pictures, XHTMLContentHandler xhtml) throws SAXException, TikaException, IOException {
        int i;
        ArrayList<CharacterRun> controls = new ArrayList<CharacterRun>();
        ArrayList<CharacterRun> texts = new ArrayList<CharacterRun>();
        boolean has14 = false;
        for (i = index + 1; i < p.numCharacterRuns(); ++i) {
            CharacterRun cr = p.getCharacterRun(i);
            if (cr.text().equals("\u0013")) {
                int increment = this.handleSpecialCharacterRuns(p, i + 1, skipStyling, pictures, xhtml);
                i += increment;
                continue;
            }
            if (cr.text().equals("\u0014")) {
                has14 = true;
                continue;
            }
            if (cr.text().equals("\u0015")) {
                if (has14) break;
                texts = controls;
                controls = new ArrayList();
                break;
            }
            if (has14) {
                texts.add(cr);
                continue;
            }
            controls.add(cr);
        }
        if (controls.size() > 0) {
            String text = ((CharacterRun)controls.get(0)).text();
            for (int j = 1; j < controls.size(); ++j) {
                text = text + ((CharacterRun)controls.get(j)).text();
            }
            if ((text.startsWith("HYPERLINK") || text.startsWith(" HYPERLINK")) && text.indexOf(34) > -1) {
                int start = text.indexOf(34) + 1;
                int end = this.findHyperlinkEnd(text, start);
                String url = "";
                if (start >= 0 && start < end && end <= text.length()) {
                    url = text.substring(start, end);
                }
                xhtml.startElement("a", "href", url);
                this.closeStyleElements(skipStyling, xhtml);
                for (CharacterRun cr : texts) {
                    this.handleCharacterRun(cr, skipStyling, xhtml);
                }
                this.closeStyleElements(skipStyling, xhtml);
                xhtml.endElement("a");
            } else {
                for (CharacterRun cr : texts) {
                    if (pictures.hasPicture(cr)) {
                        Picture picture = pictures.getFor(cr);
                        this.handlePictureCharacterRun(cr, picture, pictures, xhtml);
                        continue;
                    }
                    this.handleCharacterRun(cr, skipStyling, xhtml);
                }
            }
        } else {
            for (CharacterRun cr : texts) {
                this.handleCharacterRun(cr, skipStyling, xhtml);
            }
        }
        return i - index;
    }

    private void closeStyleElements(boolean skipStyling, XHTMLContentHandler xhtml) throws SAXException {
        if (skipStyling) {
            return;
        }
        if (this.curStrikeThrough) {
            xhtml.endElement("s");
            this.curStrikeThrough = false;
        }
        if (this.curItalic) {
            xhtml.endElement("i");
            this.curItalic = false;
        }
        if (this.curBold) {
            xhtml.endElement("b");
            this.curBold = false;
        }
    }

    private int findHyperlinkEnd(String text, int start) {
        int end = text.lastIndexOf(34);
        if (end > start) {
            return end;
        }
        end = text.lastIndexOf(8221);
        if (end > start) {
            return end;
        }
        end = text.lastIndexOf(13);
        if (end > start) {
            return end;
        }
        return text.length();
    }

    private void handlePictureCharacterRun(CharacterRun cr, Picture picture, PicturesSource pictures, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        if (!this.isRendered(cr) || picture == null) {
            return;
        }
        String extension = picture.suggestFileExtension();
        int pictureNumber = pictures.pictureNumber(picture);
        String filename = "image" + pictureNumber + (extension.length() > 0 ? "." + extension : "");
        String mimeType = picture.getMimeType();
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "src", "src", "CDATA", "embedded:" + filename);
        attr.addAttribute("", "alt", "alt", "CDATA", filename);
        xhtml.startElement("img", attr);
        xhtml.endElement("img");
        if (!pictures.hasOutput(picture)) {
            TikaInputStream stream = TikaInputStream.get((byte[])picture.getContent());
            this.handleEmbeddedResource(stream, filename, null, mimeType, xhtml, false);
            pictures.recordOutput(picture);
        }
    }

    private void addTextIfAny(XHTMLContentHandler xhtml, String section, String text) throws SAXException {
        if (text != null && text.length() > 0) {
            xhtml.startElement("div", "class", section);
            xhtml.element("p", text);
            xhtml.endElement("div");
        }
    }

    protected void parseWord6(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parseWord6(filesystem.getRoot(), xhtml);
    }

    protected void parseWord6(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HWPFOldDocument doc = new HWPFOldDocument(root);
        Word6Extractor extractor = new Word6Extractor(doc);
        for (String p : extractor.getParagraphText()) {
            xhtml.element("p", p);
        }
    }

    private boolean isRendered(CharacterRun cr) {
        return cr == null || !cr.isMarkedDeleted();
    }

    static {
        fixedParagraphStyles.put("Default", defaultParagraphStyle);
        fixedParagraphStyles.put("Normal", defaultParagraphStyle);
        fixedParagraphStyles.put("heading", new TagAndStyle("h1", null));
        fixedParagraphStyles.put("Heading", new TagAndStyle("h1", null));
        fixedParagraphStyles.put("Title", new TagAndStyle("h1", "title"));
        fixedParagraphStyles.put("Subtitle", new TagAndStyle("h2", "subtitle"));
        fixedParagraphStyles.put("HTML Preformatted", new TagAndStyle("pre", null));
    }

    private static class PicturesSource {
        private PicturesTable picturesTable;
        private Set<Picture> output = new HashSet<Picture>();
        private Map<Integer, Picture> lookup;
        private List<Picture> nonU1based;
        private List<Picture> all;
        private int pn = 0;

        private PicturesSource(HWPFDocument doc) {
            this.picturesTable = doc.getPicturesTable();
            this.all = this.picturesTable.getAllPictures();
            this.lookup = new HashMap<Integer, Picture>();
            for (Picture p : this.all) {
                this.lookup.put(p.getStartOffset(), p);
            }
            this.nonU1based = new ArrayList<Picture>();
            this.nonU1based.addAll(this.all);
            Range r = doc.getRange();
            for (int i = 0; i < r.numCharacterRuns(); ++i) {
                CharacterRun cr = r.getCharacterRun(i);
                if (!this.picturesTable.hasPicture(cr)) continue;
                Picture p = this.getFor(cr);
                int at = this.nonU1based.indexOf(p);
                this.nonU1based.set(at, null);
            }
        }

        private boolean hasPicture(CharacterRun cr) {
            return this.picturesTable.hasPicture(cr);
        }

        private void recordOutput(Picture picture) {
            this.output.add(picture);
        }

        private boolean hasOutput(Picture picture) {
            return this.output.contains(picture);
        }

        private int pictureNumber(Picture picture) {
            return this.all.indexOf(picture) + 1;
        }

        private Picture getFor(CharacterRun cr) {
            return this.lookup.get(cr.getPicOffset());
        }

        private Picture nextUnclaimed() {
            Picture p = null;
            while (this.pn < this.nonU1based.size()) {
                p = this.nonU1based.get(this.pn);
                ++this.pn;
                if (p == null) continue;
                return p;
            }
            return null;
        }
    }

    public static class TagAndStyle {
        private String tag;
        private String styleClass;

        public TagAndStyle(String tag, String styleClass) {
            this.tag = tag;
            this.styleClass = styleClass;
        }

        public String getTag() {
            return this.tag;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public boolean isHeading() {
            return this.tag.length() == 2 && this.tag.startsWith("h");
        }
    }
}

