/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.tika.parser.microsoft.AbstractListManager;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl;

public class XWPFListManager
extends AbstractListManager {
    private static final boolean OVERRIDE_AVAILABLE;
    private static final String SKIP_FORMAT;
    private final XWPFNumbering numbering;

    public XWPFListManager(XWPFDocument document) {
        this.numbering = document.getNumbering();
    }

    public String getFormattedNumber(XWPFParagraph paragraph) {
        if (this.numbering == null) {
            return "";
        }
        int currNumId = paragraph.getNumID().intValue();
        XWPFNum xwpfNum = this.numbering.getNum(paragraph.getNumID());
        if (xwpfNum == null) {
            return "";
        }
        CTNum ctNum = xwpfNum.getCTNum();
        CTDecimalNumber abNum = ctNum.getAbstractNumId();
        int currAbNumId = abNum.getVal().intValue();
        AbstractListManager.ParagraphLevelCounter lc = (AbstractListManager.ParagraphLevelCounter)this.listLevelMap.get(currAbNumId);
        AbstractListManager.LevelTuple[] overrideTuples = (AbstractListManager.LevelTuple[])this.overrideTupleMap.get(currNumId);
        if (lc == null) {
            lc = this.loadLevelTuples(abNum);
        }
        if (overrideTuples == null) {
            overrideTuples = this.loadOverrideTuples(ctNum, lc.getNumberOfLevels());
        }
        String formattedString = lc.incrementLevel(paragraph.getNumIlvl().intValue(), overrideTuples);
        this.listLevelMap.put(currAbNumId, lc);
        this.overrideTupleMap.put(currNumId, overrideTuples);
        return formattedString;
    }

    private AbstractListManager.LevelTuple[] loadOverrideTuples(CTNum ctNum, int length) {
        AbstractListManager.LevelTuple[] levelTuples = new AbstractListManager.LevelTuple[length];
        int overrideLength = ctNum.sizeOfLvlOverrideArray();
        if (overrideLength == 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            CTNumLvl ctNumLvl;
            AbstractListManager.LevelTuple tuple = i >= overrideLength ? new AbstractListManager.LevelTuple("%" + i + ".") : ((ctNumLvl = ctNum.getLvlOverrideArray(i)) != null ? this.buildTuple(i, ctNumLvl.getLvl()) : new AbstractListManager.LevelTuple("%" + i + "."));
            levelTuples[i] = tuple;
        }
        return levelTuples;
    }

    private AbstractListManager.ParagraphLevelCounter loadLevelTuples(CTDecimalNumber abNum) {
        XWPFAbstractNum abstractNum = this.numbering.getAbstractNum(abNum.getVal());
        CTAbstractNum ctAbstractNum = abstractNum.getCTAbstractNum();
        AbstractListManager.LevelTuple[] levels = new AbstractListManager.LevelTuple[ctAbstractNum.sizeOfLvlArray()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = this.buildTuple(i, ctAbstractNum.getLvlArray(i));
        }
        return new AbstractListManager.ParagraphLevelCounter(levels);
    }

    private AbstractListManager.LevelTuple buildTuple(int level, CTLvl ctLvl) {
        boolean isLegal = false;
        int start = 1;
        int restart = -1;
        String lvlText = "%" + level + ".";
        String numFmt = "decimal";
        if (ctLvl != null && ctLvl.getIsLgl() != null) {
            isLegal = true;
        }
        if (ctLvl != null && ctLvl.getNumFmt() != null && ctLvl.getNumFmt().getVal() != null) {
            numFmt = ctLvl.getNumFmt().getVal().toString();
        }
        if (ctLvl != null && ctLvl.getLvlRestart() != null && ctLvl.getLvlRestart().getVal() != null) {
            restart = ctLvl.getLvlRestart().getVal().intValue();
        }
        start = ctLvl != null && ctLvl.getStart() != null && ctLvl.getStart().getVal() != null ? ctLvl.getStart().getVal().intValue() : ("decimal".equals(numFmt) || "ordinal".equals(numFmt) || "decimalZero".equals(numFmt) ? 0 : 1);
        if (ctLvl != null && ctLvl.getLvlText() != null && ctLvl.getLvlText().getVal() != null) {
            lvlText = ctLvl.getLvlText().getVal();
        }
        return new AbstractListManager.LevelTuple(start, restart, lvlText, numFmt, isLegal);
    }

    static {
        SKIP_FORMAT = Character.toString('\uf0b7');
        boolean b = false;
        try {
            Class.forName("org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl");
            b = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        OVERRIDE_AVAILABLE = false;
        boolean bl = false;
    }
}

