/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.GitCommand;
import org.uberfire.java.nio.fs.jgit.util.exceptions.ConcurrentRefUpdateException;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class Squash
extends GitCommand {
    private final String branch;
    private final Git git;
    private String squashedCommitMessage;
    private String startCommitString;

    public Squash(Git git, String branch, String startCommitString, String squashedCommitMessage) {
        this.git = git;
        this.squashedCommitMessage = squashedCommitMessage;
        this.branch = branch;
        this.startCommitString = startCommitString;
    }

    public Optional<Void> execute() {
        RevCommit startCommit;
        Repository repo = this.git.getRepository();
        this.isBare(repo);
        this.checkIfCommitIsPresentAtBranch(this.git, this.branch, this.startCommitString);
        Git git = new Git(repo);
        ObjectId startCommitObjectId = this.getStartCommit(git, this.startCommitString);
        RevWalk revWalk = new RevWalk(repo);
        RevCommit parent = startCommit = this.getRevCommit(startCommitObjectId, revWalk);
        if (startCommit.getParentCount() > 0) {
            parent = this.getRevCommit(startCommitObjectId, revWalk).getParent(0);
        }
        Ref head = this.getHead(repo);
        this.markStart(revWalk, parent, head);
        revWalk.sort(RevSort.REVERSE);
        PersonIdent commitAuthor = null;
        Map<String, ObjectId> content = new HashMap<String, ObjectId>();
        for (RevCommit commit : revWalk) {
            commitAuthor = commit.getAuthorIdent();
            content = this.collectPathAndObjectIdFromTree(repo, revWalk, commit);
        }
        revWalk.dispose();
        ObjectInserter odi = repo.newObjectInserter();
        ObjectId indexTreeId = this.createTemporaryIndex(git, content, odi);
        CommitBuilder commit = this.createCommit(parent, commitAuthor, indexTreeId, this.squashedCommitMessage);
        ObjectId commitId = this.insertCommitIntoRepositoryAndFlush(odi, commit);
        this.updateReferenceAndReleaseRevisionWalk(git, revWalk, commitId);
        return Optional.empty();
    }

    private void checkIfCommitIsPresentAtBranch(Git git, String branch, String startCommitString) {
        try {
            ObjectId id = JGitUtil.resolveObjectId(git, branch);
            Spliterator log = git.log().add((AnyObjectId)id).call().spliterator();
            Optional<RevCommit> result = StreamSupport.stream(log, false).filter(elem -> elem.getName().equals(startCommitString)).findFirst();
            result.orElseThrow(() -> new GitException("Commit is not present at branch " + branch));
        }
        catch (GitAPIException | IncorrectObjectTypeException | MissingObjectException e) {
            throw new GitException("A problem occurred when trying to get commit list", e);
        }
    }

    private ObjectId createTemporaryIndex(Git git, Map<String, ObjectId> content, ObjectInserter odi) {
        try {
            DirCache index = JGitUtil.createTemporaryIndexForContent(git, content);
            return index.writeTree(odi);
        }
        catch (IOException e) {
            String message = "Cannot create temporary index form content";
            throw new GitException(message, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateReferenceAndReleaseRevisionWalk(Git git, RevWalk revWalk, ObjectId commitId) {
        try {
            RevCommit revCommit = this.getRevCommit(commitId, revWalk);
            RefUpdate ru = git.getRepository().updateRef(this.getBranch());
            ru.setExpectedOldObjectId((AnyObjectId)git.getRepository().resolve("HEAD"));
            ru.setNewObjectId((AnyObjectId)commitId);
            ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
            RefUpdate.Result rc = ru.forceUpdate();
            switch (rc) {
                case NEW: 
                case FORCED: 
                case FAST_FORWARD: {
                    return;
                }
                case REJECTED: 
                case LOCK_FAILURE: {
                    throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                }
                default: {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", commitId.toString(), rc));
                }
            }
        }
        catch (IOException e) {
            String message = "Cannot update commit reference";
            throw new GitException(message, e);
        }
        finally {
            revWalk.close();
        }
    }

    private String getBranch() {
        return "refs/heads/" + this.branch;
    }

    private Map<String, ObjectId> collectPathAndObjectIdFromTree(Repository repo, RevWalk revWalk, RevCommit commit) {
        try {
            HashMap<String, ObjectId> content = new HashMap<String, ObjectId>();
            RevTree tree = this.getRevTree(revWalk, commit);
            TreeWalk treeWalk = new TreeWalk(repo);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                if (treeWalk.isSubtree()) {
                    treeWalk.enterSubtree();
                    continue;
                }
                ObjectId objectId = treeWalk.getObjectId(0);
                content.put(treeWalk.getPathString(), objectId);
            }
            return content;
        }
        catch (IOException e) {
            String message = "Impossible to collect path and objectId from Tree";
            throw new GitException(message, e);
        }
    }

    private void markStart(RevWalk revWalk, RevCommit parent, Ref head) {
        try {
            revWalk.markStart(this.getRevCommit(head.getObjectId(), revWalk));
            revWalk.markUninteresting(parent);
        }
        catch (IOException e) {
            String message = "Cannot mark start a revision tree";
            throw new GitException(message, e);
        }
    }

    private Ref getHead(Repository repository) {
        try {
            return repository.getRef("HEAD");
        }
        catch (IOException e) {
            String message = "Cannot get HEAD from Repository";
            throw new GitException(message, e);
        }
    }

    private ObjectId insertCommitIntoRepositoryAndFlush(ObjectInserter odi, CommitBuilder commit) {
        try {
            ObjectId commitId = odi.insert(commit);
            odi.flush();
            return commitId;
        }
        catch (IOException e) {
            String message = String.format("Cannot get insert commits into repository (TreeId = %s)", commit.getTreeId());
            throw new GitException(message, e);
        }
    }

    private CommitBuilder createCommit(RevCommit parent, PersonIdent commitAuthor, ObjectId indexTreeId, String squashedCommitMessage) {
        CommitBuilder commit = new CommitBuilder();
        commit.setAuthor(commitAuthor);
        commit.setCommitter(commitAuthor);
        commit.setEncoding("UTF-8");
        commit.setMessage(squashedCommitMessage);
        commit.setParentId((AnyObjectId)parent.getId());
        commit.setTreeId((AnyObjectId)indexTreeId);
        return commit;
    }
}

