/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.helpers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.service.M2RepoService;

public class HttpGetHelper {
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final long DEFAULT_EXPIRE_TIME = 604800000L;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    @Inject
    private M2RepoService m2RepoService;
    @Inject
    private GuvnorM2Repository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException {
        String requestedFile = request.getPathInfo();
        if (requestedFile == null) {
            response.sendError(404);
            return;
        }
        requestedFile = URLDecoder.decode(requestedFile, "UTF-8");
        File mavenRootDir = new File(this.repository.getM2RepositoryRootDir());
        String canonicalDirPath = mavenRootDir.getCanonicalPath() + File.separator;
        String canonicalEntryPath = new File(mavenRootDir, requestedFile).getCanonicalPath();
        if (!canonicalEntryPath.startsWith(canonicalDirPath)) {
            response.sendError(404);
            return;
        }
        requestedFile = canonicalEntryPath.substring(canonicalDirPath.length());
        File file = new File(mavenRootDir, requestedFile);
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        String fileName = file.getName();
        long length = file.length();
        long lastModified = file.lastModified();
        String eTag = fileName + "_" + length + "_" + lastModified;
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifNoneMatch != null && HttpGetHelper.matches(ifNoneMatch, eTag)) {
            response.setHeader("ETag", eTag);
            response.sendError(304);
            return;
        }
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
            response.setHeader("ETag", eTag);
            response.sendError(304);
            return;
        }
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null && !HttpGetHelper.matches(ifMatch, eTag)) {
            response.sendError(412);
            return;
        }
        long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            response.sendError(412);
            return;
        }
        Range full = new Range(0L, length - 1L, length);
        ArrayList ranges = new ArrayList();
        String contentType = context.getMimeType(fileName);
        boolean acceptsGzip = false;
        String disposition = "inline";
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (contentType.startsWith("text")) {
            String acceptEncoding = request.getHeader("Accept-Encoding");
            acceptsGzip = acceptEncoding != null && HttpGetHelper.accepts(acceptEncoding, "gzip");
            contentType = contentType + ";charset=UTF-8";
        } else if (!contentType.startsWith("image")) {
            String accept = request.getHeader("Accept");
            disposition = accept != null && HttpGetHelper.accepts(accept, contentType) ? "inline" : "attachment";
        }
        response.reset();
        response.setBufferSize(10240);
        response.setHeader("Content-Disposition", disposition + ";filename=\"" + fileName + "\"");
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("ETag", eTag);
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Expires", System.currentTimeMillis() + 604800000L);
        RandomAccessFile input = null;
        OutputStream output = null;
        try {
            input = new RandomAccessFile(file, "r");
            output = response.getOutputStream();
            if (ranges.isEmpty() || ranges.get(0) == full) {
                Range r = full;
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                if (acceptsGzip) {
                    response.setHeader("Content-Encoding", "gzip");
                    output = new GZIPOutputStream(output, 10240);
                } else {
                    response.setHeader("Content-Length", String.valueOf(r.length));
                }
                HttpGetHelper.copyRange(input, output, r.start, r.length);
            } else if (ranges.size() == 1) {
                Range r = (Range)ranges.get(0);
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                response.setHeader("Content-Length", String.valueOf(r.length));
                response.setStatus(206);
                HttpGetHelper.copyRange(input, output, r.start, r.length);
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                response.setStatus(206);
                ServletOutputStream sos = (ServletOutputStream)output;
                for (Range r : ranges) {
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                    HttpGetHelper.copyRange(input, output, r.start, r.length);
                }
                sos.println();
                sos.println("--MULTIPART_BYTERANGES--");
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static void copyRange(RandomAccessFile input, OutputStream output, long start, long length) throws IOException {
        byte[] buffer = new byte[10240];
        if (input.length() == length) {
            int read;
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    protected class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

