/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class SplashScreenActivityGenerator
extends AbstractGenerator {
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String onStartup1ParameterMethodName;
        String onStartup0ParameterMethodName;
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = (TypeElement)element;
        String identifier = ClientAPIModule.getWbSplashScreenIdentifierValueOnClass(classElement);
        boolean isEnabled = ClientAPIModule.getWbSplashScreenIsEnabledValueOnClass(classElement);
        String beanActivatorClass = GeneratorUtils.getBeanActivatorClassName(classElement, processingEnvironment);
        ExecutableElement onStartupMethod = GeneratorUtils.getOnStartupMethodForNonEditors(classElement, processingEnvironment);
        if (onStartupMethod == null) {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = null;
        } else if (onStartupMethod.getParameters().isEmpty()) {
            onStartup0ParameterMethodName = onStartupMethod.getSimpleName().toString();
            onStartup1ParameterMethodName = null;
        } else {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = onStartupMethod.getSimpleName().toString();
        }
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String getSplashFilterMethodName = GeneratorUtils.getSplashFilterMethodName(classElement, processingEnvironment);
        String getBodyHeightMethodName = GeneratorUtils.getBodyHeightMethodName(classElement, processingEnvironment);
        String getInterceptMethodName = GeneratorUtils.getInterceptMethodName(classElement, processingEnvironment);
        List<String> qualifiers = GeneratorUtils.getAllQualifiersDeclarationFromType(classElement);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Identifier: " + identifier);
            messager.printMessage(Diagnostic.Kind.NOTE, "isEnabled: " + isEnabled);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup0ParameterMethodName: " + onStartup0ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onCloseMethodName: " + onCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onShutdownMethodName: " + onShutdownMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onOpenMethodName: " + onOpenMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleMethodName: " + getTitleMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleWidgetMethodName: " + getTitleWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getWidgetMethodName: " + getWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidget: " + Boolean.toString(isWidget));
            messager.printMessage(Diagnostic.Kind.NOTE, "hasUberView: " + Boolean.toString(hasUberView));
            messager.printMessage(Diagnostic.Kind.NOTE, "getSplashFilterMethodName: " + getSplashFilterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getInterceptMethodName: " + getInterceptMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getBodyHeightMethodName: " + getBodyHeightMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Qualifiers: " + String.join((CharSequence)", ", qualifiers));
        }
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchSplashScreen must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            String msg = "The WorkbenchSplashScreen both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            messager.printMessage(Diagnostic.Kind.WARNING, "The WorkbenchSplashScreen both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.", classElement);
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchSplashScreen must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        if (getSplashFilterMethodName == null) {
            throw new GenerationException("The WorkbenchSplashScreen must provide a @SplashFilter annotated method to return a org.uberfire.workbench.model.SplashScreenFilter.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("isEnabled", isEnabled);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("beanActivatorClass", beanActivatorClass);
        root.put("onStartup0ParameterMethodName", onStartup0ParameterMethodName);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("getSplashFilterMethodName", getSplashFilterMethodName);
        root.put("getInterceptMethodName", getInterceptMethodName);
        root.put("getBodyHeightMethodName", getBodyHeightMethodName);
        root.put("qualifiers", qualifiers);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = this.config.getTemplate("splashScreen.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

