/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.locking;

import java.util.UUID;
import net.sf.webdav.locking.ResourceLocks;

public class LockedObject {
    private ResourceLocks _resourceLocks;
    private String _path;
    private String _id;
    protected int _lockDepth;
    protected long _expiresAt;
    protected String[] _owner = null;
    protected LockedObject[] _children = null;
    protected LockedObject _parent = null;
    protected boolean _exclusive = false;
    protected String _type = null;

    public LockedObject(ResourceLocks resLocks, String path, boolean temporary) {
        this._path = path;
        this._id = UUID.randomUUID().toString();
        this._resourceLocks = resLocks;
        if (!temporary) {
            this._resourceLocks._locks.put(path, this);
            this._resourceLocks._locksByID.put(this._id, this);
        } else {
            this._resourceLocks._tempLocks.put(path, this);
            this._resourceLocks._tempLocksByID.put(this._id, this);
        }
        ++this._resourceLocks._cleanupCounter;
    }

    public boolean addLockedObjectOwner(String owner) {
        if (this._owner == null) {
            this._owner = new String[1];
        } else {
            int size = this._owner.length;
            String[] newLockObjectOwner = new String[size + 1];
            for (int i = 0; i < size; ++i) {
                if (!this._owner[i].equals(owner)) continue;
                return false;
            }
            System.arraycopy(this._owner, 0, newLockObjectOwner, 0, size);
            this._owner = newLockObjectOwner;
        }
        this._owner[this._owner.length - 1] = owner;
        return true;
    }

    public void removeLockedObjectOwner(String owner) {
        try {
            if (this._owner != null) {
                int size = this._owner.length;
                for (int i = 0; i < size; ++i) {
                    if (!this._owner[i].equals(owner)) continue;
                    String[] newLockedObjectOwner = new String[size - 1];
                    for (int j = 0; j < size - 1; ++j) {
                        newLockedObjectOwner[j] = j < i ? this._owner[j] : this._owner[j + 1];
                    }
                    this._owner = newLockedObjectOwner;
                }
                if (this._owner.length == 0) {
                    this._owner = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("LockedObject.removeLockedObjectOwner()");
            System.out.println(e.toString());
        }
    }

    public void addChild(LockedObject newChild) {
        if (this._children == null) {
            this._children = new LockedObject[0];
        }
        int size = this._children.length;
        LockedObject[] newChildren = new LockedObject[size + 1];
        System.arraycopy(this._children, 0, newChildren, 0, size);
        newChildren[size] = newChild;
        this._children = newChildren;
    }

    public void removeLockedObject() {
        if (this != this._resourceLocks._root && !this.getPath().equals("/")) {
            int size = this._parent._children.length;
            for (int i = 0; i < size; ++i) {
                if (!this._parent._children[i].equals(this)) continue;
                LockedObject[] newChildren = new LockedObject[size - 1];
                for (int i2 = 0; i2 < size - 1; ++i2) {
                    newChildren[i2] = i2 < i ? this._parent._children[i2] : this._parent._children[i2 + 1];
                }
                if (newChildren.length != 0) {
                    this._parent._children = newChildren;
                    break;
                }
                this._parent._children = null;
                break;
            }
            this._resourceLocks._locksByID.remove(this.getID());
            this._resourceLocks._locks.remove(this.getPath());
        }
    }

    public void removeTempLockedObject() {
        if (this != this._resourceLocks._tempRoot && this._parent != null && this._parent._children != null) {
            int size = this._parent._children.length;
            for (int i = 0; i < size; ++i) {
                if (!this._parent._children[i].equals(this)) continue;
                LockedObject[] newChildren = new LockedObject[size - 1];
                for (int i2 = 0; i2 < size - 1; ++i2) {
                    newChildren[i2] = i2 < i ? this._parent._children[i2] : this._parent._children[i2 + 1];
                }
                if (newChildren.length != 0) {
                    this._parent._children = newChildren;
                    break;
                }
                this._parent._children = null;
                break;
            }
            this._resourceLocks._tempLocksByID.remove(this.getID());
            this._resourceLocks._tempLocks.remove(this.getPath());
        }
    }

    public boolean checkLocks(boolean exclusive, int depth) {
        return this.checkParents(exclusive) && this.checkChildren(exclusive, depth);
    }

    private boolean checkParents(boolean exclusive) {
        if (this._path.equals("/")) {
            return true;
        }
        if (this._owner == null) {
            return this._parent != null && this._parent.checkParents(exclusive);
        }
        return !this._exclusive && !exclusive && this._parent.checkParents(exclusive);
    }

    private boolean checkChildren(boolean exclusive, int depth) {
        if (this._children == null) {
            return this._owner == null || !this._exclusive && !exclusive;
        }
        if (this._owner == null) {
            if (depth != 0) {
                boolean canLock = true;
                int limit = this._children.length;
                for (int i = 0; i < limit; ++i) {
                    if (this._children[i].checkChildren(exclusive, depth - 1)) continue;
                    canLock = false;
                }
                return canLock;
            }
            return true;
        }
        return !this._exclusive && !exclusive;
    }

    public void refreshTimeout(int timeout) {
        this._expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
    }

    public long getTimeoutMillis() {
        return this._expiresAt - System.currentTimeMillis();
    }

    public boolean hasExpired() {
        if (this._expiresAt != 0L) {
            return System.currentTimeMillis() > this._expiresAt;
        }
        return true;
    }

    public String getID() {
        return this._id;
    }

    public String[] getOwner() {
        return this._owner;
    }

    public String getPath() {
        return this._path;
    }

    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this._exclusive;
    }

    public boolean isShared() {
        return !this._exclusive;
    }

    public String getType() {
        return this._type;
    }

    public int getLockDepth() {
        return this._lockDepth;
    }
}

