/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collections;
import java.util.Map;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.opengis.referencing.ReferenceIdentifier;

public final class DefinitionURI {
    public static final String PREFIX = "urn:ogc:def";
    public static final char SEPARATOR = ':';
    private static final Map<String, String> PATHS = Collections.singletonMap("crs", "//www.opengis.net/gml/srs/");
    public boolean isHTTP;
    public String type;
    public String authority;
    public String version;
    public String code;
    public String[] parameters;

    private DefinitionURI() {
    }

    public static DefinitionURI parse(String string) {
        ArgumentChecks.ensureNonNull("uri", string);
        DefinitionURI definitionURI = null;
        int n = -1;
        block11: for (int i = 0; i <= 6; ++i) {
            String string2;
            int n2 = n + 1;
            if ((n = string.indexOf(58, n2)) < 0) {
                if (i != 6) {
                    return null;
                }
                n = string.length();
            }
            switch (i) {
                case 0: {
                    if (DefinitionURI.regionMatches("http", string, n2, n)) {
                        definitionURI = new DefinitionURI();
                        return DefinitionURI.codeForHTTP(null, null, string, n + 1, definitionURI) != null ? definitionURI : null;
                    }
                    string2 = "urn";
                    break;
                }
                case 1: {
                    if (DefinitionURI.regionMatches("ogc", string, n2, n)) continue block11;
                    string2 = "x-ogc";
                    break;
                }
                case 2: {
                    string2 = "def";
                    break;
                }
                default: {
                    String string3 = CharSequences.trimWhitespaces(string, n2, n).toString();
                    if (string3.isEmpty()) {
                        string3 = null;
                    }
                    switch (i) {
                        case 3: {
                            definitionURI = new DefinitionURI();
                            definitionURI.type = string3;
                            continue block11;
                        }
                        case 4: {
                            definitionURI.authority = string3;
                            continue block11;
                        }
                        case 5: {
                            definitionURI.version = string3;
                            continue block11;
                        }
                        case 6: {
                            definitionURI.code = string3;
                            continue block11;
                        }
                        default: {
                            throw new AssertionError(i);
                        }
                    }
                }
            }
            if (DefinitionURI.regionMatches(string2, string, n2, n)) continue;
            return null;
        }
        if (++n < string.length()) {
            definitionURI.parameters = (String[])CharSequences.split(string.substring(n), ':');
        }
        return definitionURI;
    }

    static boolean regionMatches(String string, String string2, int n, int n2) {
        int n3 = (n2 = CharSequences.skipTrailingWhitespaces(string2, n = CharSequences.skipLeadingWhitespaces(string2, n, n2), n2)) - n;
        return n3 == string.length() && string2.regionMatches(true, n, string, 0, n3);
    }

    private static String codeIgnoreVersion(String string, int n) {
        int n2 = string.length();
        if ((n = CharSequences.skipLeadingWhitespaces(string, n, n2)) >= n2) {
            return null;
        }
        int n3 = string.indexOf(58, n);
        if (n3 >= 0 && ((n = CharSequences.skipLeadingWhitespaces(string, n3 + 1, n2)) >= n2 || string.indexOf(58, n) >= 0)) {
            return null;
        }
        return string.substring(n, CharSequences.skipTrailingWhitespaces(string, n, n2));
    }

    public static String codeOf(String string, String string2, String string3) {
        String string4;
        ArgumentChecks.ensureNonNull("type", string);
        ArgumentChecks.ensureNonNull("authority", string2);
        ArgumentChecks.ensureNonNull("uri", string3);
        int n = string3.indexOf(58);
        if (n < 0) {
            return CharSequences.trimWhitespaces(string3);
        }
        int n2 = CharSequences.skipLeadingWhitespaces(string3, 0, n);
        int n3 = CharSequences.skipTrailingWhitespaces(string3, n2, n) - n2;
        if (n3 == string2.length() && string3.regionMatches(true, n2, string2, 0, n3)) {
            return DefinitionURI.codeIgnoreVersion(string3, n + 1);
        }
        switch (n3) {
            case 3: {
                string4 = "urn";
                break;
            }
            case 4: {
                string4 = "http";
                break;
            }
            default: {
                return null;
            }
        }
        if (!string3.regionMatches(true, n2, string4, 0, n3)) {
            return null;
        }
        if (n3 == 4) {
            return DefinitionURI.codeForHTTP(string, string2, string3, n + 1, null);
        }
        block10: for (int i = 0; i != 4; ++i) {
            n2 = n + 1;
            if ((n = string3.indexOf(58, n2)) < 0) {
                return null;
            }
            switch (i) {
                case 0: {
                    if (DefinitionURI.regionMatches("ogc", string3, n2, n)) continue block10;
                    string4 = "x-ogc";
                    break;
                }
                case 1: {
                    string4 = "def";
                    break;
                }
                case 2: {
                    string4 = string;
                    break;
                }
                case 3: {
                    string4 = string2;
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            if (DefinitionURI.regionMatches(string4, string3, n2, n)) continue;
            return null;
        }
        return DefinitionURI.codeIgnoreVersion(string3, n + 1);
    }

    private static String codeForHTTP(String string, String string2, String string3, int n, DefinitionURI definitionURI) {
        Object object;
        Map<String, String> map = PATHS;
        if (string != null && (object = map.get(string)) == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            int n2;
            String string4 = (String)entry.getValue();
            if (!string3.regionMatches(true, n, string4, 0, string4.length())) continue;
            n += string4.length();
            if (string2 == null) {
                string2 = string3.substring(n, DefinitionURI.skipIdentifierPart(string3, n));
            } else if (!string3.regionMatches(true, n, string2, 0, string2.length())) continue;
            if ((n += string2.length()) >= (n2 = string3.length()) || string3.charAt(n) != '.' || (n = string3.indexOf(35, n + 1)) < 0) continue;
            String string5 = CharSequences.trimWhitespaces(string3, n + 1, n2).toString();
            if (definitionURI != null) {
                definitionURI.isHTTP = true;
                definitionURI.type = (String)entry.getKey();
                definitionURI.authority = string2;
                definitionURI.code = string5;
            }
            return string5;
        }
        return null;
    }

    private static int skipIdentifierPart(String string, int n) {
        int n2;
        while (n < string.length() && Character.isUnicodeIdentifierPart(n2 = string.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        return n;
    }

    public static String format(String string, ReferenceIdentifier referenceIdentifier) {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        for (int i = 0; i < 4; ++i) {
            String string2;
            switch (i) {
                case 0: {
                    string2 = string;
                    break;
                }
                case 1: {
                    string2 = referenceIdentifier.getCodeSpace();
                    break;
                }
                case 2: {
                    string2 = referenceIdentifier.getVersion();
                    break;
                }
                case 3: {
                    string2 = referenceIdentifier.getCode();
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            if (Utilities.appendUnicodeIdentifier(stringBuilder.append(':'), '\u0000', string2, ".-", false) || i == 2) continue;
            return null;
        }
        return stringBuilder.toString();
    }

    public String toURN() {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        int n = 4;
        if (this.parameters != null) {
            n += this.parameters.length;
        }
        for (int i = 0; i < n; ++i) {
            String string;
            switch (i) {
                case 0: {
                    string = this.type;
                    break;
                }
                case 1: {
                    string = this.authority;
                    break;
                }
                case 2: {
                    string = this.version;
                    break;
                }
                case 3: {
                    string = this.code;
                    break;
                }
                default: {
                    string = this.parameters[i - 4];
                }
            }
            stringBuilder.append(':');
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        String string;
        if (this.isHTTP && (string = PATHS.get(this.type)) != null) {
            return "http:" + string + this.authority + ".xml#" + this.code;
        }
        return this.toURN();
    }
}

