/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public class Version
implements CharSequence,
Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 8402041502662929792L;
    private static final String SEPARATORS = ".-";
    public static final Version SIS = new Version("0.6");
    private static final Version[] CONSTANTS = new Version[]{new Version("1"), new Version("2")};
    private final String version;
    private transient String[] components;
    private transient Comparable<?>[] parsed;
    private transient int hashCode;

    public Version(String string) {
        ArgumentChecks.ensureNonNull("version", string);
        this.version = string;
    }

    public static Version valueOf(int ... nArray) {
        int n;
        Integer[] integerArray;
        Version version;
        if (nArray.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)20, "components"));
        }
        int n2 = nArray[0];
        if (nArray.length == 1) {
            if (n2 >= 1 && n2 <= CONSTANTS.length) {
                return CONSTANTS[n2 - 1];
            }
            version = new Version(Integer.toString(n2));
        } else {
            integerArray = new StringBuilder().append(n2);
            for (n = 1; n < nArray.length; ++n) {
                integerArray.append('.').append(nArray[n]);
            }
            version = new Version(integerArray.toString());
        }
        integerArray = new Integer[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            integerArray[n] = nArray[n];
        }
        version.parsed = integerArray;
        return version;
    }

    public Comparable<?> getMajor() {
        return this.getComponent(0);
    }

    public Comparable<?> getMinor() {
        return this.getComponent(1);
    }

    public Comparable<?> getRevision() {
        return this.getComponent(2);
    }

    final synchronized Comparable<?> getComponent(int n) {
        Comparable<?> comparable;
        if (this.parsed == null) {
            if (this.components == null) {
                comparable = new StringTokenizer(this.version, SEPARATORS);
                this.components = new String[((StringTokenizer)((Object)comparable)).countTokens()];
                int n2 = 0;
                while (((StringTokenizer)((Object)comparable)).hasMoreTokens()) {
                    this.components[n2] = ((StringTokenizer)((Object)comparable)).nextToken();
                    ++n2;
                }
            }
            this.parsed = new Comparable[this.components.length];
        }
        if (n >= this.parsed.length) {
            return null;
        }
        comparable = this.parsed[n];
        if (comparable == null) {
            String string = CharSequences.trimWhitespaces(this.components[n]);
            try {
                comparable = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                comparable = string;
            }
            this.parsed[n] = comparable;
        }
        return comparable;
    }

    private static int getTypeRank(Object object) {
        if (object instanceof CharSequence) {
            return 0;
        }
        if (object instanceof Number) {
            return 1;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public int compareTo(Version version, int n) {
        ArgumentChecks.ensureNonNull("other", version);
        ArgumentChecks.ensurePositive("limit", n);
        for (int i = 0; i < n; ++i) {
            Comparable<?> comparable = this.getComponent(i);
            Comparable<?> comparable2 = version.getComponent(i);
            if (comparable == null) {
                return comparable2 == null ? 0 : -1;
            }
            if (comparable2 == null) {
                return 1;
            }
            int n2 = Version.getTypeRank(comparable) - Version.getTypeRank(comparable2);
            if (n2 != 0) {
                return n2;
            }
            int n3 = comparable.compareTo(comparable2);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    @Override
    public int compareTo(Version version) {
        return this.compareTo(version, Integer.MAX_VALUE);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            return this.compareTo((Version)object) == 0;
        }
        return false;
    }

    @Override
    public int length() {
        return this.version.length();
    }

    @Override
    public char charAt(int n) {
        return this.version.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.version.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Comparable<?> comparable;
            int n = 307244416;
            int n2 = 0;
            while ((comparable = this.getComponent(n2)) != null) {
                n = n * 31 + comparable.hashCode();
                ++n2;
            }
            if (n == 0) {
                n = -1;
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }
}

