/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.enums;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.util.MVELSafeHelper;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.enums.EnumDropdownService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class EnumDropdownServiceImpl
implements EnumDropdownService {
    private static final Logger logger = LoggerFactory.getLogger(EnumDropdownServiceImpl.class);
    @Inject
    private BuildInfoService buildInfoService;
    @Inject
    private KieProjectService projectService;

    public String[] loadDropDownExpression(Path resource, String[] valuePairs, String expression) {
        KieProject project = (KieProject)this.projectService.resolveProject(resource);
        if (project == null) {
            logger.error("A Project could not be resolved for path '" + resource.toURI() + "'. No enums will be returned.");
            return null;
        }
        KieModule module = this.buildInfoService.getBuildInfo((Project)project).getKieModuleIgnoringErrors();
        if (module == null) {
            logger.error("A KieModule could not be resolved for path '" + resource.toURI() + "'. No enums will be returned.");
            return null;
        }
        ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
        return this.loadDropDownExpression(classLoader, valuePairs, expression);
    }

    protected String[] loadDropDownExpression(ClassLoader classLoader, String[] valuePairs, String expression) {
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            for (String valuePair : valuePairs) {
                if (valuePair == null) {
                    return new String[0];
                }
                String[] pair = valuePair.split("=");
                if (pair.length == 1) {
                    String[] swap = new String[]{pair[0], ""};
                    pair = swap;
                }
                context.put(pair[0], pair[1]);
            }
            expression = (String)TemplateRuntime.eval((String)expression, context);
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pconf.setClassLoader(classLoader);
            Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)pctx);
            Object result = MVELSafeHelper.getEvaluator().executeExpression((Object)compiled, new HashMap());
            if (result instanceof String[]) {
                return (String[])result;
            }
            if (result instanceof List) {
                List l = (List)result;
                String[] xs = new String[l.size()];
                for (int i = 0; i < xs.length; ++i) {
                    Object el = l.get(i);
                    xs[i] = el.toString();
                }
                return xs;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

