/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectItemsIterator
implements Iterator<SelectItem> {
    private Iterator<SelectItem> items = null;
    private ListIterator<UIComponent> kids = null;

    public SelectItemsIterator(UIComponent parent) {
        this.kids = parent.getChildren().listIterator();
    }

    @Override
    public boolean hasNext() {
        Object next;
        if (this.items != null) {
            if (this.items.hasNext()) {
                return true;
            }
            this.items = null;
        }
        if ((next = this.findNextValidChild()) != null) {
            this.kids.previous();
            return true;
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.items != null) {
            return this.items.next();
        }
        UIComponent kid = (UIComponent)this.findNextValidChild();
        if (kid instanceof UISelectItem) {
            UISelectItem ui = (UISelectItem)kid;
            SelectItem item = (SelectItem)ui.getValue();
            if (item == null) {
                item = new SelectItem(ui.getItemValue(), ui.getItemLabel(), ui.getItemDescription(), ui.isItemDisabled(), ui.isItemEscaped());
            }
            return item;
        }
        if (kid instanceof UISelectItems) {
            UISelectItems ui = (UISelectItems)kid;
            Object value = ui.getValue();
            if (value instanceof SelectItem) {
                return (SelectItem)value;
            }
            if (value instanceof SelectItem[]) {
                this.items = Arrays.asList((SelectItem[])value).iterator();
                return this.next();
            }
            if (value instanceof List) {
                this.items = ((List)value).iterator();
                return this.next();
            }
            if (value instanceof Map) {
                ArrayList<SelectItem> list = new ArrayList<SelectItem>();
                for (Object key : ((Map)value).keySet()) {
                    Object val;
                    if (key == null || (val = ((Map)value).get(key)) == null) continue;
                    list.add(new SelectItem(val, key.toString(), null));
                }
                this.items = list.iterator();
                return this.next();
            }
            throw new IllegalArgumentException();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Object findNextValidChild() {
        if (this.kids.hasNext()) {
            UIComponent next = this.kids.next();
            while (this.kids.hasNext() && !(next instanceof UISelectItem) && !(next instanceof UISelectItems)) {
                next = this.kids.next();
            }
            if (next instanceof UISelectItem || next instanceof UISelectItems) {
                return next;
            }
        }
        return null;
    }
}

