/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;

public class ExternalViewGenerator {
    static Logger _logger = Logger.getLogger(ExternalViewGenerator.class);

    public Map<String, Map<String, Set<String>>> getRouterMapFromExternalView(List<ZNRecord> externalViewList) {
        TreeMap<String, Map<String, Set<String>>> result = new TreeMap<String, Map<String, Set<String>>>();
        for (ZNRecord nodeView : externalViewList) {
            Map<String, Map<String, String>> partitionNodeStateMap = nodeView.getMapFields();
            for (String partitionId : partitionNodeStateMap.keySet()) {
                if (!result.containsKey(partitionId)) {
                    result.put(partitionId, new TreeMap());
                }
                Map<String, String> nodeStateMap = partitionNodeStateMap.get(partitionId);
                for (String nodeName : nodeStateMap.keySet()) {
                    String state = nodeStateMap.get(nodeName);
                    if (!((Map)result.get(partitionId)).containsKey(state)) {
                        ((Map)result.get(partitionId)).put(state, new TreeSet());
                    }
                    ((Set)((Map)result.get(partitionId)).get(state)).add(nodeName);
                }
            }
        }
        return result;
    }

    public List<ZNRecord> computeExternalView(Map<String, List<ZNRecord>> currentStates, List<ZNRecord> idealStates) {
        ArrayList<ZNRecord> resultList = new ArrayList<ZNRecord>();
        HashMap<String, ZNRecord> resultRoutingTable = new HashMap<String, ZNRecord>();
        if (idealStates != null) {
            for (ZNRecord idealState : idealStates) {
                ZNRecord defaultExternalView = new ZNRecord(idealState.getId());
                resultRoutingTable.put(idealState.getId(), defaultExternalView);
            }
        } else {
            assert (!currentStates.isEmpty());
            return resultList;
        }
        for (String nodeName : currentStates.keySet()) {
            List<ZNRecord> znStates = currentStates.get(nodeName);
            for (ZNRecord nodeStateRecord : znStates) {
                Map<String, Map<String, String>> resourceStates = nodeStateRecord.getMapFields();
                for (String stateUnitKey : resourceStates.keySet()) {
                    Map<String, String> partitionStates = resourceStates.get(stateUnitKey);
                    String resourceName = partitionStates.get(Message.Attributes.RESOURCE_NAME.toString());
                    ZNRecord partitionStatus = (ZNRecord)resultRoutingTable.get(resourceName);
                    if (partitionStatus == null) {
                        partitionStatus = new ZNRecord(resourceName);
                        resultRoutingTable.put(resourceName, partitionStatus);
                    }
                    String currentStateKey = CurrentState.CurrentStateProperty.CURRENT_STATE.toString();
                    if (!partitionStatus.getMapFields().containsKey(stateUnitKey)) {
                        partitionStatus.setMapField(stateUnitKey, new TreeMap<String, String>());
                    }
                    partitionStatus.getMapField(stateUnitKey).put(nodeName, partitionStates.get(currentStateKey));
                }
            }
        }
        for (ZNRecord record : resultRoutingTable.values()) {
            resultList.add(record);
        }
        return resultList;
    }
}

