/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;

public class HierarchicalDataHolder<T> {
    private static final Logger logger = Logger.getLogger((String)HierarchicalDataHolder.class.getName());
    AtomicReference<Node<T>> root;
    AtomicLong currentVersion;
    private final ZkClient _zkClient;
    private final String _rootPath;
    private final FileFilter _filter;

    public HierarchicalDataHolder(ZkClient client, String rootPath, FileFilter filter) {
        this._zkClient = client;
        this._rootPath = rootPath;
        this._filter = filter;
        this.root = new AtomicReference();
        this.currentVersion = new AtomicLong(1L);
        this.refreshData();
    }

    public long getVersion() {
        return this.currentVersion.get();
    }

    public boolean refreshData() {
        Node newRoot = new Node();
        boolean dataChanged = this.refreshRecursively(this.root.get(), newRoot, this._rootPath);
        if (dataChanged) {
            this.currentVersion.getAndIncrement();
            this.root.set(newRoot);
            return true;
        }
        return false;
    }

    private boolean refreshRecursively(Node<T> oldRoot, Node<T> newRoot, String path) {
        boolean dataChanged = false;
        Stat newStat = this._zkClient.getStat(path);
        Stat oldStat = oldRoot != null ? oldRoot.stat : null;
        newRoot.name = path;
        if (newStat != null) {
            if (oldStat == null) {
                newRoot.stat = newStat;
                newRoot.data = this._zkClient.readData(path, true);
                dataChanged = true;
            } else if (newStat.equals((Object)oldStat)) {
                newRoot.stat = oldStat;
                newRoot.data = oldRoot.data;
            } else {
                dataChanged = true;
                newRoot.stat = newStat;
                newRoot.data = this._zkClient.readData(path, true);
            }
            if (newStat.getNumChildren() > 0) {
                List children = this._zkClient.getChildren(path);
                for (String child : children) {
                    Node oldChild;
                    String newPath = path + "/" + child;
                    Node node = oldChild = oldRoot != null && oldRoot.children != null ? oldRoot.children.get(child) : null;
                    if (newRoot.children == null) {
                        newRoot.children = new ConcurrentHashMap();
                    }
                    if (!newRoot.children.contains(child)) {
                        newRoot.children.put(child, new Node());
                    }
                    Node newChild = newRoot.children.get(child);
                    boolean childChanged = this.refreshRecursively(oldChild, newChild, newPath);
                    dataChanged = dataChanged || childChanged;
                }
            }
        } else {
            logger.info((Object)(path + " does not exist"));
        }
        return dataChanged;
    }

    public void print() {
        logger.info((Object)("START " + this._rootPath));
        LinkedList stack = new LinkedList();
        stack.push(this.root.get());
        while (!stack.isEmpty()) {
            Node pop = (Node)stack.pop();
            if (pop == null) continue;
            logger.info((Object)("name:" + pop.name));
            logger.info((Object)("\tdata:" + pop.data));
            if (pop.children == null) continue;
            for (Node child : pop.children.values()) {
                stack.push(child);
            }
        }
        logger.info((Object)("END " + this._rootPath));
    }

    static class Node<T> {
        String name;
        Stat stat;
        T data;
        ConcurrentHashMap<String, Node<T>> children;

        Node() {
        }
    }
}

