/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.store;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.helix.HelixException;
import org.apache.helix.store.PropertySerializer;
import org.apache.helix.store.PropertyStoreException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class PropertyJsonSerializer<T>
implements PropertySerializer<T> {
    private static Logger LOG = Logger.getLogger(PropertyJsonSerializer.class);
    private final Class<T> _clazz;

    public PropertyJsonSerializer(Class<T> clazz) {
        this._clazz = clazz;
    }

    @Override
    public byte[] serialize(T data) throws PropertyStoreException {
        ObjectMapper mapper = new ObjectMapper();
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        serializationConfig.set(SerializationConfig.Feature.INDENT_OUTPUT, true);
        serializationConfig.set(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        serializationConfig.set(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, data);
            if (sw.toString().getBytes().length > 1024000) {
                throw new HelixException("Data size larger than 1M. Write empty string to zk.");
            }
            return sw.toString().getBytes();
        }
        catch (Exception e) {
            LOG.error((Object)("Error during serialization of data (first 1k): " + sw.toString().substring(0, 1024)), (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public T deserialize(byte[] bytes) throws PropertyStoreException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, true);
        deserializationConfig.set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        try {
            Object value = mapper.readValue((InputStream)bais, this._clazz);
            return (T)value;
        }
        catch (Exception e) {
            LOG.error((Object)("Error during deserialization of bytes: " + new String(bytes)), (Throwable)e);
            return null;
        }
    }
}

