/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.descr;

import org.kie.workbench.common.services.datamodeller.parser.JavaParser;
import org.kie.workbench.common.services.datamodeller.parser.JavaParserBase;
import org.kie.workbench.common.services.datamodeller.parser.JavaParserFactory;
import org.kie.workbench.common.services.datamodeller.parser.descr.AnnotationDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.DescriptorFactory;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.FieldDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.MethodDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.PackageDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.QualifiedNameDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TextTokenElementDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.util.ParserUtil;

public class DescriptorFactoryImpl
implements DescriptorFactory {
    public static DescriptorFactory getInstance() {
        return new DescriptorFactoryImpl();
    }

    @Override
    public MethodDescr createMethodDescr(String source) throws Exception {
        return this.createMethodDescr(source, false);
    }

    @Override
    public MethodDescr createMethodDescr(String source, boolean includeIndent) throws Exception {
        JavaParser parser = JavaParserFactory.newParser(source, JavaParserBase.ParserMode.PARSE_METHOD);
        MethodDescr methodDescr = parser.methodDeclaration().method;
        ParserUtil.setSourceBufferTMP(methodDescr, parser.getSourceBuffer());
        if (includeIndent) {
            ParserUtil.populateUnManagedElements(0, parser.getSourceBuffer().length() - 1, methodDescr);
        } else {
            ParserUtil.populateUnManagedElements(methodDescr);
        }
        ParserUtil.setSourceBufferTMP(methodDescr, parser.getSourceBuffer());
        return methodDescr;
    }

    @Override
    public FieldDescr createFieldDescr(String source) throws Exception {
        return this.createFieldDescr(source, false);
    }

    @Override
    public FieldDescr createFieldDescr(String source, boolean includeIndent) throws Exception {
        JavaParser parser = JavaParserFactory.newParser(source, JavaParserBase.ParserMode.PARSE_FIELD);
        FieldDescr fieldDescr = parser.fieldDeclaration().field;
        ParserUtil.setSourceBufferTMP(fieldDescr, parser.getSourceBuffer());
        if (includeIndent) {
            ParserUtil.populateUnManagedElements(0, parser.getSourceBuffer().length() - 1, fieldDescr);
        } else {
            ParserUtil.populateUnManagedElements(fieldDescr);
        }
        ParserUtil.setSourceBufferTMP(fieldDescr, parser.getSourceBuffer());
        return fieldDescr;
    }

    @Override
    public IdentifierDescr createIdentifierDescr(String source) throws Exception {
        IdentifierDescr identifierDescr = new IdentifierDescr(source, 0, source.length() - 1, 1, 0);
        identifierDescr.setSourceBuffer(new StringBuilder(source));
        return identifierDescr;
    }

    @Override
    public TypeDescr createTypeDescr(String source) throws Exception {
        JavaParser parser = JavaParserFactory.newParser(source, JavaParserBase.ParserMode.PARSE_TYPE);
        TypeDescr result = parser.type().typeDescr;
        ParserUtil.setSourceBufferTMP(result, parser.getSourceBuffer());
        return result;
    }

    @Override
    public AnnotationDescr createAnnotationDescr(String source) throws Exception {
        return this.createAnnotationDescr(source, false);
    }

    @Override
    public AnnotationDescr createAnnotationDescr(String source, boolean includeIndent) throws Exception {
        JavaParser parser = JavaParserFactory.newParser(source);
        AnnotationDescr annotationDescr = parser.annotation().annotationDescr;
        ParserUtil.setSourceBufferTMP(annotationDescr, parser.getSourceBuffer());
        if (includeIndent) {
            ParserUtil.populateUnManagedElements(0, parser.getSourceBuffer().length() - 1, annotationDescr);
        } else {
            ParserUtil.populateUnManagedElements(annotationDescr);
        }
        ParserUtil.setSourceBufferTMP(annotationDescr, parser.getSourceBuffer());
        return annotationDescr;
    }

    @Override
    public PackageDescr createPackageDescr(String source) throws Exception {
        JavaParser parser = JavaParserFactory.newParser(source, JavaParserBase.ParserMode.PARSE_PACKAGE);
        PackageDescr result = parser.packageDeclaration().packageDec;
        ParserUtil.setSourceBufferTMP(result, parser.getSourceBuffer());
        return result;
    }

    @Override
    public QualifiedNameDescr createQualifiedNameDescr(String source) throws Exception {
        JavaParser parser = JavaParserFactory.newParser(source, JavaParserBase.ParserMode.PARSE_QUALIFIED_NAME);
        QualifiedNameDescr result = parser.qualifiedName().qnameDec;
        ParserUtil.setSourceBufferTMP(result, parser.getSourceBuffer());
        return result;
    }

    @Override
    public JavaTokenDescr createJavaTokenDescr(ElementDescriptor.ElementType tokenType, String source) {
        JavaTokenDescr javaTokenDescr = new JavaTokenDescr(tokenType, source, 0, source.length() - 1, 1, 0);
        javaTokenDescr.setSourceBuffer(new StringBuilder(source));
        return javaTokenDescr;
    }

    @Override
    public JavaTokenDescr createExtendsTokenDescr() {
        return this.createJavaTokenDescr(ElementDescriptor.ElementType.JAVA_EXTENDS, "extends");
    }

    @Override
    public TextTokenElementDescr createTextTokenDescr(String text) {
        TextTokenElementDescr textTokenDescr = new TextTokenElementDescr(text, 0, text.length() - 1, 1, 0);
        textTokenDescr.setSourceBuffer(new StringBuilder(text));
        return textTokenDescr;
    }
}

