/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    DataStoreRegistry() {
        this.loader = ServiceLoader.load(DataStoreProvider.class);
    }

    DataStoreRegistry(ClassLoader classLoader) {
        ArgumentChecks.ensureNonNull("loader", classLoader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, classLoader);
    }

    public String probeContentType(Object object) throws DataStoreException {
        ArgumentChecks.ensureNonNull("storage", object);
        ProbeProviderPair probeProviderPair = this.lookup(object, false);
        return probeProviderPair != null ? probeProviderPair.probe.getMimeType() : null;
    }

    public DataStore open(Object object) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull("storage", object);
        return this.lookup((Object)object, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object object, boolean bl) throws DataStoreException {
        StorageConnector storageConnector = object instanceof StorageConnector ? (StorageConnector)object : new StorageConnector(object);
        Object object2 = null;
        LinkedList<ProbeProviderPair> linkedList = null;
        try {
            Object object3;
            DataStoreProvider dataStoreProvider;
            Iterator<DataStoreProvider> iterator;
            Object object4 = this.loader;
            synchronized (object4) {
                iterator = this.loader.iterator();
                dataStoreProvider = iterator.hasNext() ? iterator.next() : null;
            }
            while (dataStoreProvider != null) {
                object4 = dataStoreProvider.probeContent(storageConnector);
                if (((ProbeResult)object4).isSupported()) {
                    object2 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4);
                    linkedList = null;
                    break;
                }
                if (ProbeResult.INSUFFICIENT_BYTES.equals(object4)) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<ProbeProviderPair>();
                    }
                    linkedList.add(new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4));
                } else if (ProbeResult.UNDETERMINED.equals(object4)) {
                    object2 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4);
                }
                object3 = this.loader;
                synchronized (object3) {
                    dataStoreProvider = iterator.hasNext() ? iterator.next() : null;
                }
            }
            if (linkedList != null) {
                block10: while (!linkedList.isEmpty() && storageConnector.prefetch()) {
                    object4 = linkedList.iterator();
                    while (object4.hasNext()) {
                        object3 = (ProbeProviderPair)object4.next();
                        ((ProbeProviderPair)object3).probe = dataStoreProvider.probeContent(storageConnector);
                        if (((ProbeProviderPair)object3).probe.isSupported()) {
                            object2 = object3;
                            break block10;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(((ProbeProviderPair)object3).probe)) continue;
                        if (ProbeResult.UNDETERMINED.equals(((ProbeProviderPair)object3).probe)) {
                            object2 = object3;
                        }
                        object4.remove();
                    }
                }
            }
            if (bl && object2 != null) {
                ((ProbeProviderPair)object2).store = ((ProbeProviderPair)object2).provider.open(storageConnector);
                storageConnector = null;
            }
        }
        finally {
            if (storageConnector != null && storageConnector != object) {
                storageConnector.closeAllExcept(null);
            }
        }
        if (bl && object2 == null) {
            throw new UnsupportedStorageException(Errors.format((short)115, storageConnector.getStorageName()));
        }
        return object2;
    }
}

