/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.sql.DataSource;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.storage.ChannelImageInputStream;
import org.apache.sis.internal.storage.IOUtilities;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InputStreamAdapter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

public class StorageConnector
implements Serializable {
    private static final long serialVersionUID = 2524083964906593093L;
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final int MINIMAL_BUFFER_SIZE = 256;
    private final Object storage;
    private transient String name;
    private transient String extension;
    private transient Map<Class<?>, Object> views;
    private transient Map<Object, Object> viewsToClose;
    private transient Map<OptionKey<?>, Object> options;

    public StorageConnector(Object object) {
        ArgumentChecks.ensureNonNull("storage", object);
        this.storage = object;
    }

    public <T> T getOption(OptionKey<T> optionKey) {
        ArgumentChecks.ensureNonNull("key", optionKey);
        return optionKey.getValueFrom(this.options);
    }

    public <T> void setOption(OptionKey<T> optionKey, T t) {
        ArgumentChecks.ensureNonNull("key", optionKey);
        this.options = optionKey.setValueInto(this.options, t);
    }

    public Object getStorage() {
        return this.storage;
    }

    public String getStorageName() {
        if (this.name == null) {
            this.name = IOUtilities.filename(this.storage);
            if (this.name == null) {
                this.name = Classes.getShortClassName(this.storage);
            }
        }
        return this.name;
    }

    public String getFileExtension() {
        if (this.extension == null) {
            this.extension = IOUtilities.extension(this.storage);
        }
        return this.extension;
    }

    public <T> T getStorageAs(Class<T> clazz) throws IllegalArgumentException, DataStoreException {
        Object object;
        ArgumentChecks.ensureNonNull("type", clazz);
        if (this.views != null) {
            Object object2 = this.views.get(clazz);
            if (object2 != null) {
                return object2 != Void.TYPE ? (T)clazz.cast(object2) : null;
            }
        } else {
            this.views = new IdentityHashMap();
        }
        boolean bl = false;
        try {
            if (clazz == ByteBuffer.class) {
                this.createByteBuffer();
                bl = true;
            } else if (clazz == DataInput.class) {
                this.createDataInput();
                bl = true;
            } else if (clazz == ChannelDataInput.class) {
                this.createChannelDataInput(false);
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw new DataStoreException(Errors.format((short)7, this.getStorageName()), iOException);
        }
        if (bl) {
            return this.getView(clazz);
        }
        try {
            object = this.createView(clazz);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new DataStoreException(Errors.format((short)7, this.getStorageName()), exception);
        }
        T t = clazz.cast(object);
        this.addView(clazz, t);
        return t;
    }

    private void createChannelDataInput(boolean bl) throws IOException {
        ReadableByteChannel readableByteChannel = IOUtilities.open(this.storage, this.getOption(OptionKey.URL_ENCODING), this.getOption(OptionKey.OPEN_OPTIONS));
        ChannelDataInput channelDataInput = null;
        if (readableByteChannel != null) {
            this.addViewToClose(readableByteChannel, this.storage);
            ByteBuffer byteBuffer = this.getOption(OptionKey.BYTE_BUFFER);
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocate(4096);
            }
            String string = this.getStorageName();
            channelDataInput = bl ? new ChannelImageInputStream(string, readableByteChannel, byteBuffer, false) : new ChannelDataInput(string, readableByteChannel, byteBuffer, false);
            this.addViewToClose(channelDataInput, readableByteChannel);
        }
        this.addView(ChannelDataInput.class, channelDataInput);
    }

    private void createDataInput() throws IOException {
        DataInput dataInput;
        if (this.storage instanceof DataInput) {
            dataInput = (DataInput)this.storage;
        } else {
            ChannelDataInput channelDataInput;
            if (!this.views.containsKey(ChannelDataInput.class)) {
                this.createChannelDataInput(true);
            }
            if ((channelDataInput = this.getView(ChannelDataInput.class)) == null) {
                dataInput = ImageIO.createImageInputStream(this.storage);
                this.addViewToClose(dataInput, this.storage);
            } else if (channelDataInput instanceof DataInput) {
                dataInput = (DataInput)((Object)channelDataInput);
            } else {
                dataInput = new ChannelImageInputStream(channelDataInput);
                if (this.views.put(ChannelDataInput.class, dataInput) != channelDataInput) {
                    throw new ConcurrentModificationException();
                }
                this.addViewToClose(dataInput, channelDataInput.channel);
            }
        }
        this.addView(DataInput.class, dataInput);
    }

    private void createByteBuffer() throws IOException, DataStoreException {
        if (!this.views.containsKey(ChannelDataInput.class)) {
            this.createChannelDataInput(false);
        }
        ByteBuffer byteBuffer = null;
        ChannelDataInput channelDataInput = this.getView(ChannelDataInput.class);
        if (channelDataInput != null) {
            byteBuffer = channelDataInput.buffer.asReadOnlyBuffer();
        } else {
            ImageInputStream imageInputStream = this.getStorageAs(ImageInputStream.class);
            if (imageInputStream != null) {
                imageInputStream.mark();
                byte[] byArray = new byte[256];
                int n = imageInputStream.read(byArray);
                imageInputStream.reset();
                if (n >= 1) {
                    byteBuffer = ByteBuffer.wrap(byArray).order(imageInputStream.getByteOrder());
                    byteBuffer.limit(n);
                }
            }
        }
        this.addView(ByteBuffer.class, byteBuffer);
    }

    final boolean prefetch() throws DataStoreException {
        try {
            ByteBuffer byteBuffer;
            ChannelDataInput channelDataInput = this.getView(ChannelDataInput.class);
            if (channelDataInput != null) {
                return channelDataInput.prefetch() >= 0;
            }
            ImageInputStream imageInputStream = this.getView(ImageInputStream.class);
            if (imageInputStream != null && (byteBuffer = this.getView(ByteBuffer.class)) != null) {
                int n = byteBuffer.limit();
                int n2 = imageInputStream.read(byteBuffer.array(), n, byteBuffer.capacity() - n);
                if (n2 >= 0) {
                    byteBuffer.limit(n + n2);
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            throw new DataStoreException(Errors.format((short)9, this.getStorageName()), iOException);
        }
        return false;
    }

    private Object createView(Class<?> clazz) throws IllegalArgumentException, Exception {
        if (clazz == String.class) {
            return IOUtilities.toString(this.storage);
        }
        if (clazz == Connection.class) {
            if (this.storage instanceof Connection) {
                return this.storage;
            }
            if (this.storage instanceof DataSource) {
                Connection connection = ((DataSource)this.storage).getConnection();
                this.addViewToClose(connection, this.storage);
                return connection;
            }
            return null;
        }
        if (clazz == ImageInputStream.class) {
            DataInput dataInput = this.getStorageAs(DataInput.class);
            return dataInput instanceof ImageInputStream ? dataInput : null;
        }
        if (clazz == InputStream.class) {
            if (this.storage instanceof InputStream) {
                return this.storage;
            }
            DataInput dataInput = this.getStorageAs(DataInput.class);
            if (dataInput instanceof InputStream) {
                return (InputStream)((Object)dataInput);
            }
            if (dataInput instanceof ImageInputStream) {
                InputStreamAdapter inputStreamAdapter = new InputStreamAdapter((ImageInputStream)dataInput);
                this.addViewToClose(inputStreamAdapter, dataInput);
                return inputStreamAdapter;
            }
            return null;
        }
        if (clazz == Reader.class) {
            if (this.storage instanceof Reader) {
                return this.storage;
            }
            InputStream inputStream = this.getStorageAs(InputStream.class);
            if (inputStream != null) {
                Charset charset = this.getOption(OptionKey.ENCODING);
                InputStreamReader inputStreamReader = charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream);
                this.addViewToClose(inputStreamReader, inputStream);
                return inputStreamReader;
            }
            return null;
        }
        throw new IllegalArgumentException(Errors.format((short)118, clazz));
    }

    private <T> void addView(Class<T> clazz, T t) {
        if (this.views.put(clazz, t != null ? t : Void.TYPE) != null) {
            throw new ConcurrentModificationException();
        }
    }

    private <T> T getView(Class<T> clazz) {
        Object object = this.views.get(clazz);
        return object != Void.TYPE ? (T)clazz.cast(object) : null;
    }

    private void addViewToClose(Object object, Object object2) {
        if (this.viewsToClose == null) {
            this.viewsToClose = new IdentityHashMap<Object, Object>(4);
        }
        if (this.viewsToClose.put(object, object2) != null) {
            throw new AssertionError(object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void closeAllExcept(Object linkedList) throws DataStoreException {
        void var3_10;
        void var3_6;
        Map<Object, Object> map = this.viewsToClose;
        this.viewsToClose = Collections.emptyMap();
        this.views = Collections.emptyMap();
        if (map == null) {
            if (this.storage != linkedList && JDK7.isAutoCloseable(this.storage)) {
                try {
                    JDK7.close(this.storage);
                }
                catch (Exception exception) {
                    throw new DataStoreException(exception);
                }
            }
            return;
        }
        map.put(this.storage, null);
        if (linkedList != null) {
            LinkedList<Object> object = new LinkedList<Object>();
            LinkedList linkedList2 = linkedList;
            do {
                Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    if (entry.getValue() != linkedList2) continue;
                    object.add(entry.getKey());
                    iterator.remove();
                }
            } while ((linkedList2 = object.poll()) != null);
        }
        LinkedList linkedList3 = linkedList;
        while (var3_6 != null) {
            Object object = map.remove(var3_6);
        }
        for (Object object : map.values().toArray()) {
            map.remove(object);
        }
        Object var3_9 = null;
        for (Object object : map.keySet()) {
            if (!JDK7.isAutoCloseable(object)) continue;
            try {
                JDK7.close(object);
            }
            catch (Exception exception) {
                if (var3_10 != null) continue;
                DataStoreException dataStoreException = new DataStoreException(exception);
            }
        }
        if (var3_10 != null) {
            throw var3_10;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(Classes.getShortClassName(this)).append("[\u201c").append(this.getStorageName()).append('\u201d');
        if (this.options != null) {
            stringBuilder.append(", options=").append(this.options);
        }
        return stringBuilder.append(']').toString();
    }
}

