/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.events;

import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.uberfire.backend.vfs.Path;

@Portable
public class DataModelerEvent {
    protected DataObject currentDataObject;
    protected ObjectProperty currentField;
    protected Method currentMethod;
    protected Project currentProject;
    protected String source;
    protected String contextId;
    protected Path path;
    public static final String DATA_MODEL_BROWSER = "DATA_MODEL_BROWSER";
    public static final String DATA_OBJECT_BROWSER = "DATA_OBJECT_BROWSER";
    public static final String DATA_OBJECT_EDITOR = "DATA_OBJECT_EDITOR";

    public DataModelerEvent() {
    }

    public DataModelerEvent(DataObject currentDataObject) {
        this.currentDataObject = currentDataObject;
    }

    public DataModelerEvent(String contextId, String source, DataObject currentDataObject) {
        this(contextId, source, currentDataObject, null);
    }

    public DataModelerEvent(String source, DataObject currentDataObject) {
        this(null, source, currentDataObject, null);
    }

    public DataModelerEvent(String contextId, String source, DataObject currentDataObject, ObjectProperty currentField) {
        this.contextId = contextId;
        this.source = source;
        this.currentDataObject = currentDataObject;
        this.currentField = currentField;
    }

    public DataModelerEvent(String contextId, Project currentProject, DataObject currentDataObject) {
        this.contextId = contextId;
        this.currentProject = currentProject;
        this.currentDataObject = currentDataObject;
    }

    public DataModelerEvent(Project currentProject, DataObject currentDataObject) {
        this.currentProject = currentProject;
        this.currentDataObject = currentDataObject;
    }

    public DataObject getCurrentDataObject() {
        return this.currentDataObject;
    }

    public DataModelerEvent withCurrentDataObject(DataObject currentDataObject) {
        this.setCurrentDataObject(currentDataObject);
        return this;
    }

    public void setCurrentDataObject(DataObject currentDataObject) {
        this.currentDataObject = currentDataObject;
    }

    public ObjectProperty getCurrentField() {
        return this.currentField;
    }

    public DataModelerEvent withCurrentField(ObjectProperty currentField) {
        this.setCurrentField(currentField);
        return this;
    }

    public void setCurrentField(ObjectProperty currentField) {
        this.currentField = currentField;
    }

    public DataModelerEvent withCurrentProject(Project currentProject) {
        this.setCurrentProject(currentProject);
        return this;
    }

    public void setCurrentMethod(Method currentMethod) {
        this.currentMethod = currentMethod;
    }

    public Method getCurrentMethod() {
        return this.currentMethod;
    }

    public DataModelerEvent withCurrentMethod(Method currentMethod) {
        this.setCurrentMethod(currentMethod);
        return this;
    }

    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }

    public String getSource() {
        return this.source;
    }

    public DataModelerEvent withSource(String source) {
        this.setSource(source);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getContextId() {
        return this.contextId;
    }

    public DataModelerEvent withContextId(String contextId) {
        this.setContextId(contextId);
        return this;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public Path getPath() {
        return this.path;
    }

    public DataModelerEvent withPath(Path path) {
        this.setPath(path);
        return this;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public boolean isFrom(Project project) {
        return this.currentProject != null && this.currentProject.equals((Object)project);
    }

    public boolean isFrom(String source) {
        return this.source != null && this.source.equals(source);
    }

    public boolean isFromContext(String contextId) {
        return this.contextId != null && this.contextId.equals(contextId);
    }
}

