/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.util;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.drools.guvnor.client.util.AbstractLazyStackPanelHeader;
import org.drools.guvnor.client.util.LazyStackPanelHeader;
import org.drools.guvnor.client.util.LazyStackPanelRow;
import org.drools.guvnor.client.util.LoadContentCommand;

public class LazyStackPanel
extends Composite
implements HasSelectionHandlers<LazyStackPanelRow> {
    private FlexTable flexTable = new FlexTable();
    private int rowIndex = 0;

    public LazyStackPanel() {
        this.initWidget((Widget)this.flexTable);
        this.flexTable.setStyleName("guvnor-lazyStackPanel");
        this.addSelectionHandler(new SelectionHandler<LazyStackPanelRow>(){

            public void onSelection(SelectionEvent<LazyStackPanelRow> event) {
                LazyStackPanelRow row = (LazyStackPanelRow)((Object)event.getSelectedItem());
                if (row.isExpanded()) {
                    row.compress();
                } else {
                    row.expand();
                }
            }
        });
    }

    public void add(String headerText, LoadContentCommand contentLoad) {
        this.add(headerText, contentLoad, false);
    }

    public void add(String headerText, LoadContentCommand contentLoad, boolean expanded) {
        LazyStackPanelHeader header = new LazyStackPanelHeader(headerText);
        this.add(header, contentLoad, expanded);
    }

    public void add(String headerText, Image icon, LoadContentCommand contentLoad) {
        LazyStackPanelHeader header = new LazyStackPanelHeader(headerText, icon);
        this.add(header, contentLoad, false);
    }

    public void add(AbstractLazyStackPanelHeader header, LoadContentCommand contentLoad) {
        this.add(header, contentLoad, false);
    }

    public void add(AbstractLazyStackPanelHeader header, LoadContentCommand contentLoad, boolean expanded) {
        final LazyStackPanelRow row = new LazyStackPanelRow(header, contentLoad);
        header.addOpenHandler(new OpenHandler<AbstractLazyStackPanelHeader>(){

            public void onOpen(OpenEvent<AbstractLazyStackPanelHeader> event) {
                LazyStackPanel.this.selectRow(row);
            }
        });
        header.addCloseHandler(new CloseHandler<AbstractLazyStackPanelHeader>(){

            public void onClose(CloseEvent<AbstractLazyStackPanelHeader> event) {
                LazyStackPanel.this.selectRow(row);
            }
        });
        this.addHeaderRow(row);
        this.addContentRow(row.getContentPanel());
        if (expanded) {
            header.expand();
        }
    }

    private void addHeaderRow(LazyStackPanelRow row) {
        this.flexTable.setWidget(this.rowIndex, 0, (Widget)row);
        this.flexTable.getFlexCellFormatter().setStyleName(this.rowIndex, 0, "guvnor-LazyStackPanel-row-header");
        ++this.rowIndex;
    }

    private void addContentRow(SimplePanel panel) {
        this.flexTable.setWidget(this.rowIndex++, 0, (Widget)panel);
    }

    private void selectRow(LazyStackPanelRow row) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)((Object)row));
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<LazyStackPanelRow> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void swap(int firstIndex, int secondIndex) {
        Widget firstHeader = this.flexTable.getWidget(firstIndex *= 2, 0);
        Widget firstContent = this.flexTable.getWidget(firstIndex + 1, 0);
        Widget secondHeader = this.flexTable.getWidget(secondIndex *= 2, 0);
        Widget secondContent = this.flexTable.getWidget(secondIndex + 1, 0);
        this.flexTable.setWidget(firstIndex, 0, secondHeader);
        this.flexTable.setWidget(firstIndex + 1, 0, secondContent);
        this.flexTable.setWidget(secondIndex, 0, firstHeader);
        this.flexTable.setWidget(secondIndex + 1, 0, firstContent);
    }

    public Iterator<AbstractLazyStackPanelHeader> getHeaderIterator() {
        ArrayList<AbstractLazyStackPanelHeader> result = new ArrayList<AbstractLazyStackPanelHeader>();
        for (Widget widget : this.flexTable) {
            if (!(widget instanceof LazyStackPanelRow)) continue;
            result.add(((LazyStackPanelRow)widget).getHeader());
        }
        return result.iterator();
    }

    public void remove(int index) {
        this.flexTable.removeRow((index *= 2) + 1);
        this.flexTable.removeRow(index);
    }
}

