/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import java.util.Date;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupDateEditCell
extends AbstractPopupEditCell<Date, Date> {
    private final DatePicker datePicker;
    private final DateTimeFormat format;

    public PopupDateEditCell(DateTimeFormat format, boolean isReadOnly) {
        super(isReadOnly);
        if (format == null) {
            throw new IllegalArgumentException("format == null");
        }
        this.format = format;
        this.datePicker = new DatePicker();
        this.datePicker.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                Date date = (Date)event.getValue();
                PopupDateEditCell.this.setValue(PopupDateEditCell.this.lastContext, PopupDateEditCell.this.lastParent, date);
                if (PopupDateEditCell.this.valueUpdater != null) {
                    PopupDateEditCell.this.valueUpdater.update((Object)date);
                }
                PopupDateEditCell.this.panel.hide();
            }
        });
        this.vPanel.add((Widget)this.datePicker);
    }

    public void render(Cell.Context context, Date value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)this.format.format(value)));
        }
    }

    @Override
    protected void commit() {
        Date date = this.datePicker.getValue();
        this.setValue(this.lastContext, this.lastParent, date);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)date);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, Date value) {
        Date date = value;
        if (value == null) {
            Date d = new Date();
            int year = d.getYear();
            int month = d.getMonth();
            int dom = d.getDate();
            date = new Date(year, month, dom);
        }
        this.datePicker.setCurrentMonth(date);
        this.datePicker.setValue(date);
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupDateEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupDateEditCell.this.offsetX, parent.getAbsoluteTop() + PopupDateEditCell.this.offsetY);
            }
        });
    }
}

