/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

class GlobalButton
extends ImageButton {
    private final Scenario scenario;
    private final ScenarioWidget parent;
    private final SuggestionCompletionEngine suggestionCompletionEngine;

    public GlobalButton(Scenario scenario, ScenarioWidget parent) {
        super(DroolsGuvnorImages.INSTANCE.NewItem(), Constants.INSTANCE.AddANewGlobalToThisScenario());
        this.scenario = scenario;
        this.parent = parent;
        this.suggestionCompletionEngine = parent.suggestionCompletionEngine;
        this.addGlobalButtonClickHandler();
    }

    private void addGlobalButtonClickHandler() {
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewGlobalPopup popup = new NewGlobalPopup();
                popup.show();
            }
        });
    }

    private Widget getMissingGlobalsWarning() {
        HTML warning = new HTML(Constants.INSTANCE.missingGlobalsWarning());
        warning.getElement().setClassName("missingGlobalsWarning");
        return warning;
    }

    class NewGlobalPopup
    extends FormStylePopup {
        final ListBox factTypes;
        private Button addButton;
        private Widget warning;

        public NewGlobalPopup() {
            super(DroolsGuvnorImages.INSTANCE.RuleAsset(), Constants.INSTANCE.NewGlobal());
            this.factTypes = new ListBox();
            this.addButton = new AddButton();
            this.warning = GlobalButton.this.getMissingGlobalsWarning();
            this.fillFactTypes();
            this.addRow(this.warning);
            this.addAttribute(Constants.INSTANCE.GlobalColon(), (Widget)this.getHorizontalPanel());
        }

        private HorizontalPanel getHorizontalPanel() {
            HorizontalPanel insertFact = new HorizontalPanel();
            insertFact.add((Widget)this.factTypes);
            insertFact.add((Widget)this.addButton);
            return insertFact;
        }

        private void fillFactTypes() {
            if (GlobalButton.this.suggestionCompletionEngine.getGlobalVariables().length == 0) {
                this.addButton.setEnabled(false);
                this.factTypes.setEnabled(false);
                this.warning.setVisible(true);
            } else {
                this.addButton.setEnabled(true);
                this.factTypes.setEnabled(true);
                this.warning.setVisible(false);
                for (String globals : GlobalButton.this.suggestionCompletionEngine.getGlobalVariables()) {
                    this.factTypes.addItem(globals);
                }
            }
        }

        class AddButton
        extends Button {
            public AddButton() {
                super(Constants.INSTANCE.Add());
                this.addAddClickHandler();
            }

            private void addAddClickHandler() {
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        String text = NewGlobalPopup.this.factTypes.getItemText(NewGlobalPopup.this.factTypes.getSelectedIndex());
                        if (GlobalButton.this.scenario.isFactNameReserved(text)) {
                            Window.alert((String)Constants.INSTANCE.TheName0IsAlreadyInUsePleaseChooseAnotherName(text));
                        } else {
                            FactData factData = new FactData(GlobalButton.this.suggestionCompletionEngine.getGlobalVariable(text), text, false);
                            GlobalButton.this.scenario.getGlobals().add(factData);
                            GlobalButton.this.parent.renderEditor();
                            NewGlobalPopup.this.hide();
                        }
                    }
                });
            }
        }
    }
}

