/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.scorecards;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.IdentityColumn;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.widgets.CustomEditTextCell;
import org.drools.guvnor.client.widgets.DynamicSelectionCell;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.scorecards.Attribute;
import org.drools.ide.common.client.modeldriven.scorecards.Characteristic;
import org.drools.ide.common.client.modeldriven.scorecards.ScorecardModel;

public class GuidedScorecardWidget
extends Composite
implements SaveEventListener,
EditorWidget {
    private static final String[] REASON_CODE_ALGORITHMS = new String[]{"none", "pointsAbove", "pointsBelow"};
    private final String[] typesForAttributes = new String[]{"String", "int", "double", "boolean"};
    private final String[] typesForScore = new String[]{"double"};
    private final String[] typesForRC = new String[]{"List"};
    private final String[] stringOperators = new String[]{"=", "in"};
    private final String[] booleanOperators = new String[]{"true", "false"};
    private final String[] numericOperators = new String[]{"=", ">", "<", ">=", "<=", ">..<", ">=..<", ">=..<=", ">..<="};
    private VerticalPanel layout;
    private Asset asset;
    private ClientFactory clientFactory;
    private EventBus globalEventBus;
    private SimplePanel dtableContainer = new SimplePanel();
    private VerticalPanel characteristicsPanel;
    private Button btnAddCharacteristic;
    private List<DirtyableFlexTable> characteristicsTables = new ArrayList<DirtyableFlexTable>();
    private Map<DirtyableFlexTable, ListDataProvider<Attribute>> characteristicsAttrMap = new HashMap<DirtyableFlexTable, ListDataProvider<Attribute>>();
    private SuggestionCompletionEngine sce;
    private Map<String, ModelField[]> sceModelFields;
    private EnumDropDown ddUseReasonCode;
    private EnumDropDown ddReasonCodeAlgo;
    private EnumDropDown ddReasonCodeField;
    private TextBox tbBaselineScore;
    private TextBox tbInitialScore;
    private Grid scorecardPropertiesGrid;

    public void onSave(SaveCommand saveCommand) {
        try {
            ScorecardModel scorecardModel = (ScorecardModel)this.asset.getContent();
            scorecardModel.setName(this.asset.getName());
            scorecardModel.setPackageName(this.asset.getMetaData().getModuleName());
            scorecardModel.setBaselineScore(Double.parseDouble(this.tbBaselineScore.getValue()));
            scorecardModel.setInitialScore(Double.parseDouble(this.tbInitialScore.getValue()));
            scorecardModel.setReasonCodesAlgorithm(this.ddReasonCodeAlgo.getValue(this.ddReasonCodeAlgo.getSelectedIndex()));
            scorecardModel.setUseReasonCodes(this.ddUseReasonCode.getSelectedIndex() == 1);
            EnumDropDown enumDropDown = (EnumDropDown)this.scorecardPropertiesGrid.getWidget(1, 0);
            String factName = enumDropDown.getValue(enumDropDown.getSelectedIndex());
            scorecardModel.setFactName(factName);
            if (this.sce.getModelFields().get(factName) != null) {
                for (ModelField mf : (ModelField[])this.sce.getModelFields().get(factName)) {
                    if (!mf.getType().equals(factName)) continue;
                    scorecardModel.setFactName(mf.getClassName());
                    break;
                }
            }
            if ((enumDropDown = (EnumDropDown)this.scorecardPropertiesGrid.getWidget(1, 1)).getSelectedIndex() > -1) {
                String fieldName = enumDropDown.getValue(enumDropDown.getSelectedIndex());
                fieldName = fieldName.substring(0, fieldName.indexOf(":")).trim();
                scorecardModel.setFieldName(fieldName);
            } else {
                scorecardModel.setFieldName("");
            }
            if (this.ddReasonCodeField.getSelectedIndex() > -1) {
                String rcField = this.ddReasonCodeField.getValue(this.ddReasonCodeField.getSelectedIndex());
                rcField = rcField.substring(0, rcField.indexOf(":")).trim();
                scorecardModel.setReasonCodeField(rcField);
            }
            scorecardModel.getCharacteristics().clear();
            for (DirtyableFlexTable flexTable : this.characteristicsTables) {
                Characteristic characteristic = new Characteristic();
                characteristic.setName(((TextBox)flexTable.getWidget(0, 1)).getValue());
                enumDropDown = (EnumDropDown)flexTable.getWidget(2, 0);
                String simpleFactName = enumDropDown.getValue(enumDropDown.getSelectedIndex());
                if (this.sce.getModelFields().get(simpleFactName) != null) {
                    for (ModelField mf : (ModelField[])this.sce.getModelFields().get(simpleFactName)) {
                        if (!mf.getType().equals(simpleFactName)) continue;
                        characteristic.setFact(mf.getClassName());
                        break;
                    }
                }
                if ((enumDropDown = (EnumDropDown)flexTable.getWidget(2, 1)).getSelectedIndex() > -1) {
                    String fieldName = enumDropDown.getValue(enumDropDown.getSelectedIndex());
                    fieldName = fieldName.substring(0, fieldName.indexOf(":")).trim();
                    characteristic.setField(fieldName);
                } else {
                    characteristic.setField("");
                }
                characteristic.setReasonCode(((TextBox)flexTable.getWidget(2, 3)).getValue());
                String baselineScore = ((TextBox)flexTable.getWidget(2, 2)).getValue();
                try {
                    characteristic.setBaselineScore(Double.parseDouble(baselineScore));
                }
                catch (Exception e) {
                    characteristic.setBaselineScore(0.0);
                }
                scorecardModel.getCharacteristics().add(characteristic);
                characteristic.setDataType(this.getDataTypeForField(simpleFactName, characteristic.getField()));
                System.out.println(">>>SetDataType -->" + simpleFactName + "<-->" + characteristic.getField() + "<-->" + characteristic.getDataType() + "<--");
                characteristic.getAttributes().clear();
                characteristic.getAttributes().addAll(this.characteristicsAttrMap.get(flexTable).getList());
            }
            saveCommand.save();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void onAfterSave() {
    }

    public GuidedScorecardWidget(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus globalEventBus) {
        try {
            this.asset = asset;
            this.clientFactory = clientFactory;
            this.globalEventBus = globalEventBus;
            this.layout = new VerticalPanel();
            ScorecardModel scorecardModel = (ScorecardModel)asset.getContent();
            DecoratedDisclosurePanel disclosurePanel = new DecoratedDisclosurePanel("Scorecard  ( " + asset.getName() + " )");
            disclosurePanel.setWidth("100%");
            disclosurePanel.setTitle(Constants.INSTANCE.Scorecard());
            disclosurePanel.setOpen(true);
            DecoratedDisclosurePanel configPanel = new DecoratedDisclosurePanel("Setup Parameters");
            configPanel.setWidth("95%");
            configPanel.setOpen(true);
            configPanel.add(this.getScorecardProperties());
            VerticalPanel config = new VerticalPanel();
            DecoratedDisclosurePanel characteristicsPanel = new DecoratedDisclosurePanel("Characteristics");
            characteristicsPanel.setOpen(scorecardModel.getCharacteristics().size() > 0);
            characteristicsPanel.setWidth("95%");
            characteristicsPanel.add(this.getCharacteristics());
            config.setWidth("100%");
            config.add((Widget)configPanel);
            config.add((Widget)characteristicsPanel);
            disclosurePanel.add((Widget)config);
            this.layout.add((Widget)disclosurePanel);
            this.dtableContainer.setPixelSize(1000, 200);
            this.layout.add((Widget)this.dtableContainer);
            for (Characteristic characteristic : scorecardModel.getCharacteristics()) {
                DirtyableFlexTable flexTable = this.addCharacteristic(characteristic);
                for (Attribute attribute : characteristic.getAttributes()) {
                    this.addAttribute(flexTable, attribute);
                }
            }
            this.initWidget((Widget)this.layout);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private Widget getScorecardProperties() {
        if (this.sce == null) {
            this.sce = SuggestionCompletionCache.getInstance().getEngineFromCache(this.asset.getMetaData().getModuleName());
            this.sceModelFields = this.sce.getModelFields();
        }
        final ScorecardModel scorecardModel = (ScorecardModel)this.asset.getContent();
        this.scorecardPropertiesGrid = new Grid(4, 4);
        this.scorecardPropertiesGrid.setCellSpacing(5);
        this.scorecardPropertiesGrid.setCellPadding(5);
        this.tbInitialScore = TextBoxFactory.getTextBox("Double");
        this.tbInitialScore.setText(Double.toString(scorecardModel.getInitialScore()));
        String factName = scorecardModel.getFactName();
        if (factName.lastIndexOf(".") > -1) {
            factName = factName.substring(factName.lastIndexOf(".") + 1);
        }
        final EnumDropDown dropDownFields = new EnumDropDown("", new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
            }
        }, DropDownData.create((String[])new String[0]));
        EnumDropDown dropDownFacts = new EnumDropDown(factName, new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
                String selectedField = scorecardModel.getFieldName();
                selectedField = selectedField + " : double";
                dropDownFields.setDropDownData(selectedField, DropDownData.create((String[])GuidedScorecardWidget.this.getEligibleFields(newValue, GuidedScorecardWidget.this.typesForScore)));
            }
        }, DropDownData.create((String[])this.sce.getFactTypes()));
        this.ddReasonCodeField = new EnumDropDown("", new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
            }
        }, DropDownData.create((String[])new String[0]));
        String rcField = scorecardModel.getReasonCodeField() + " : List";
        this.ddReasonCodeField.setDropDownData(rcField, DropDownData.create((String[])this.getEligibleFields(factName, this.typesForRC)));
        boolean useReasonCodes = scorecardModel.isUseReasonCodes();
        String reasonCodesAlgo = scorecardModel.getReasonCodesAlgorithm();
        if (reasonCodesAlgo == null || reasonCodesAlgo.trim().length() == 0) {
            reasonCodesAlgo = "none";
        }
        this.ddUseReasonCode = this.booleanEditor(Boolean.toString(useReasonCodes));
        this.ddReasonCodeAlgo = this.dropDownEditor(DropDownData.create((String[])REASON_CODE_ALGORITHMS), reasonCodesAlgo);
        this.tbBaselineScore = TextBoxFactory.getTextBox("Double");
        this.scorecardPropertiesGrid.setText(0, 0, "Facts");
        this.scorecardPropertiesGrid.setText(0, 1, "Resultant Score Field");
        this.scorecardPropertiesGrid.setText(0, 2, "Initial Score");
        this.scorecardPropertiesGrid.setWidget(1, 0, (Widget)dropDownFacts);
        this.scorecardPropertiesGrid.setWidget(1, 1, (Widget)dropDownFields);
        this.scorecardPropertiesGrid.setWidget(1, 2, (Widget)this.tbInitialScore);
        this.scorecardPropertiesGrid.setText(2, 0, "Use Reason Codes");
        this.scorecardPropertiesGrid.setText(2, 1, "Resultant Reason Codes Field");
        this.scorecardPropertiesGrid.setText(2, 2, "Reason Codes Algorithm");
        this.scorecardPropertiesGrid.setText(2, 3, "Baseline Score");
        this.scorecardPropertiesGrid.setWidget(3, 0, (Widget)this.ddUseReasonCode);
        this.scorecardPropertiesGrid.setWidget(3, 1, (Widget)this.ddReasonCodeField);
        this.scorecardPropertiesGrid.setWidget(3, 2, (Widget)this.ddReasonCodeAlgo);
        this.scorecardPropertiesGrid.setWidget(3, 3, (Widget)this.tbBaselineScore);
        this.ddUseReasonCode.setEnabled(false);
        this.tbBaselineScore.setText(Double.toString(scorecardModel.getBaselineScore()));
        this.scorecardPropertiesGrid.getCellFormatter().setWidth(0, 0, "200px");
        this.scorecardPropertiesGrid.getCellFormatter().setWidth(0, 1, "250px");
        this.scorecardPropertiesGrid.getCellFormatter().setWidth(0, 2, "200px");
        this.scorecardPropertiesGrid.getCellFormatter().setWidth(0, 3, "200px");
        int index = Arrays.asList(this.sce.getFactTypes()).indexOf(factName);
        dropDownFacts.setSelectedIndex(index);
        dropDownFields.setDropDownData(scorecardModel.getFieldName() + " : double", DropDownData.create((String[])this.getEligibleFields(factName, this.typesForScore)));
        return this.scorecardPropertiesGrid;
    }

    private Widget getCharacteristics() {
        this.characteristicsPanel = new VerticalPanel();
        HorizontalPanel toolbar = new HorizontalPanel();
        this.btnAddCharacteristic = new Button("New Characteristic", new ClickHandler(){

            public void onClick(ClickEvent event) {
                GuidedScorecardWidget.this.addCharacteristic(null);
            }
        });
        toolbar.add((Widget)this.btnAddCharacteristic);
        toolbar.setHeight("24");
        this.characteristicsPanel.add((Widget)toolbar);
        SimplePanel gapPanel = new SimplePanel();
        gapPanel.add((Widget)new HTML("<br/>"));
        this.characteristicsPanel.add((Widget)gapPanel);
        return this.characteristicsPanel;
    }

    private void removeCharacteristic(DirtyableFlexTable selectedTable) {
        if (selectedTable != null) {
            String msg;
            TextBox tbName = (TextBox)selectedTable.getWidget(0, 1);
            String name = tbName.getValue();
            if (name == null || name.trim().length() == 0) {
                name = "Untitled";
            }
            if (Window.confirm((String)(msg = "Are you sure you want to delete '" + name + "' Characteristic?"))) {
                this.characteristicsTables.remove(selectedTable);
                this.characteristicsAttrMap.remove(selectedTable);
                Widget parent = selectedTable.getParent().getParent();
                int i = this.characteristicsPanel.getWidgetIndex(parent);
                this.characteristicsPanel.remove(parent);
                this.characteristicsPanel.remove(i);
            }
        }
    }

    private void addAttribute(DirtyableFlexTable selectedTable, Attribute attribute) {
        Attribute newAttribute = null;
        if (attribute != null) {
            this.characteristicsAttrMap.get(selectedTable).getList().add(attribute);
        } else {
            newAttribute = new Attribute();
            this.characteristicsAttrMap.get(selectedTable).getList().add(newAttribute);
        }
        this.characteristicsAttrMap.get(selectedTable).refresh();
        ((EnumDropDown)selectedTable.getWidget(2, 0)).setEnabled(false);
        ((EnumDropDown)selectedTable.getWidget(2, 1)).setEnabled(false);
        EnumDropDown edd = (EnumDropDown)selectedTable.getWidget(2, 1);
        if (edd.getSelectedIndex() > -1) {
            String field = edd.getValue(edd.getSelectedIndex());
            field = field.substring(field.indexOf(":") + 1).trim();
            CellTable cellTable = (CellTable)this.characteristicsAttrMap.get(selectedTable).getDataDisplays().iterator().next();
            DynamicSelectionCell dynamicSelectionCell = (DynamicSelectionCell)cellTable.getColumn(0).getCell();
            List<String> newOptions = null;
            if ("double".equalsIgnoreCase(field) || "int".equalsIgnoreCase(field)) {
                newOptions = Arrays.asList(this.numericOperators);
            } else if ("boolean".equalsIgnoreCase(field)) {
                newOptions = Arrays.asList(this.booleanOperators);
                CustomEditTextCell etc = (CustomEditTextCell)cellTable.getColumn(1).getCell();
                etc.setEnabled(Boolean.valueOf(false));
                ((Button)selectedTable.getWidget(0, 3)).setEnabled(this.characteristicsAttrMap.get(selectedTable).getList().size() != 2);
                if (newAttribute != null) {
                    newAttribute.setValue("N/A");
                }
            } else if ("String".equalsIgnoreCase(field)) {
                newOptions = Arrays.asList(this.stringOperators);
            }
            dynamicSelectionCell.setOptions(newOptions);
            if (newAttribute != null && newOptions != null) {
                newAttribute.setOperator(newOptions.get(0));
            }
        }
    }

    private DirtyableFlexTable addCharacteristic(final Characteristic characteristic) {
        final DirtyableFlexTable cGrid = new DirtyableFlexTable();
        cGrid.setBorderWidth(0);
        cGrid.setCellPadding(1);
        cGrid.setCellSpacing(1);
        cGrid.setStyleName("rule-ListHeader");
        Button btnAddAttribute = new Button("Add Attribute", new ClickHandler(){

            public void onClick(ClickEvent event) {
                GuidedScorecardWidget.this.addAttribute(cGrid, null);
            }
        });
        Button btnRemoveCharacteristic = new Button("Remove Characteristic", new ClickHandler(){

            public void onClick(ClickEvent event) {
                GuidedScorecardWidget.this.removeCharacteristic(cGrid);
            }
        });
        String selectedFact = "";
        if (characteristic != null && (selectedFact = characteristic.getFact()).lastIndexOf(".") > -1) {
            selectedFact = selectedFact.substring(selectedFact.lastIndexOf(".") + 1);
        }
        final EnumDropDown dropDownFields = new EnumDropDown("", new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
            }
        }, DropDownData.create((String[])new String[0]));
        EnumDropDown dropDownFacts = new EnumDropDown(selectedFact, new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
                String selectedField = "";
                if (characteristic != null) {
                    selectedField = characteristic.getField();
                    selectedField = selectedField + " : " + characteristic.getDataType();
                }
                dropDownFields.setDropDownData(selectedField, DropDownData.create((String[])GuidedScorecardWidget.this.getEligibleFields(newValue, GuidedScorecardWidget.this.typesForAttributes)));
            }
        }, DropDownData.create((String[])this.sce.getFactTypes()));
        DropDownData dropDownData = DropDownData.create((String[])this.getEligibleFields(selectedFact, this.typesForAttributes));
        dropDownFields.setDropDownData("", dropDownData);
        cGrid.setWidget(0, 0, (Widget)new Label("Name"));
        TextBox tbName = TextBoxFactory.getTextBox("String");
        cGrid.setWidget(0, 1, (Widget)tbName);
        cGrid.setWidget(0, 2, (Widget)btnRemoveCharacteristic);
        cGrid.setWidget(0, 3, (Widget)btnAddAttribute);
        cGrid.setWidget(1, 0, (Widget)new Label("Fact"));
        cGrid.setWidget(1, 1, (Widget)new Label("Characteristic"));
        cGrid.setWidget(1, 2, (Widget)new Label("Baseline Score"));
        cGrid.setWidget(1, 3, (Widget)new Label("Reason Code"));
        cGrid.setWidget(2, 0, (Widget)dropDownFacts);
        cGrid.setWidget(2, 1, (Widget)dropDownFields);
        TextBox tbBaseline = TextBoxFactory.getTextBox("Double");
        boolean useReasonCodesValue = "true".equalsIgnoreCase(this.ddUseReasonCode.getValue(this.ddUseReasonCode.getSelectedIndex()));
        tbBaseline.setEnabled(useReasonCodesValue);
        cGrid.setWidget(2, 2, (Widget)tbBaseline);
        TextBox tbReasonCode = TextBoxFactory.getTextBox("String");
        tbReasonCode.setEnabled(useReasonCodesValue);
        cGrid.setWidget(2, 3, (Widget)tbReasonCode);
        SimplePanel gapPanel = new SimplePanel();
        gapPanel.add((Widget)new HTML("<br/>"));
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)cGrid);
        panel.add(this.addAttributeCellTable(cGrid, characteristic));
        panel.setWidth("100%");
        DecoratorPanel decoratorPanel = new DecoratorPanel();
        decoratorPanel.add((Widget)panel);
        this.characteristicsPanel.add((Widget)decoratorPanel);
        this.characteristicsPanel.add((Widget)gapPanel);
        this.characteristicsTables.add(cGrid);
        cGrid.getColumnFormatter().setWidth(0, "150px");
        cGrid.getColumnFormatter().setWidth(1, "250px");
        cGrid.getColumnFormatter().setWidth(2, "150px");
        cGrid.getColumnFormatter().setWidth(3, "150px");
        if (characteristic != null) {
            tbReasonCode.setValue((Object)characteristic.getReasonCode());
            tbBaseline.setValue((Object)("" + characteristic.getBaselineScore()));
            int index = Arrays.asList(this.sce.getFactTypes()).indexOf(selectedFact);
            dropDownFacts.setSelectedIndex(index);
            String modifiedFieldName = characteristic.getField() + " : " + characteristic.getDataType();
            dropDownFields.setSelectedIndex(Arrays.asList(this.getEligibleFields(selectedFact, this.typesForAttributes)).indexOf(modifiedFieldName));
            tbName.setValue((Object)characteristic.getName());
        }
        return cGrid;
    }

    private Widget addAttributeCellTable(final DirtyableFlexTable cGrid, Characteristic characteristic) {
        final CellTable attributeCellTable = new CellTable();
        ArrayList<String> operators = new ArrayList<String>();
        String dataType = characteristic == null ? "String" : characteristic.getDataType();
        if ("String".equalsIgnoreCase(dataType)) {
            operators.addAll(Arrays.asList(this.stringOperators));
        } else if ("boolean".equalsIgnoreCase(dataType)) {
            operators.addAll(Arrays.asList(this.booleanOperators));
        } else {
            operators.addAll(Arrays.asList(this.numericOperators));
        }
        DynamicSelectionCell categoryCell = new DynamicSelectionCell(operators);
        Column<Attribute, String> operatorColumn = new Column<Attribute, String>((Cell)categoryCell){

            public String getValue(Attribute object) {
                return object.getOperator();
            }
        };
        Column<Attribute, String> valueColumn = new Column<Attribute, String>((Cell)new CustomEditTextCell()){

            public String getValue(Attribute attribute) {
                return attribute.getValue();
            }
        };
        final EditTextCell partialScoreCell = new EditTextCell();
        Column<Attribute, String> partialScoreColumn = new Column<Attribute, String>((Cell)partialScoreCell){

            public String getValue(Attribute attribute) {
                return "" + attribute.getPartialScore();
            }
        };
        Column<Attribute, String> reasonCodeColumn = new Column<Attribute, String>((Cell)new EditTextCell()){

            public String getValue(Attribute attribute) {
                return attribute.getReasonCode();
            }
        };
        ActionCell.Delegate<Attribute> delegate = new ActionCell.Delegate<Attribute>(){

            public void execute(Attribute attribute) {
                if (Window.confirm((String)"Remove this attribute?")) {
                    List list = ((ListDataProvider)GuidedScorecardWidget.this.characteristicsAttrMap.get(cGrid)).getList();
                    list.remove(attribute);
                    ((EnumDropDown)cGrid.getWidget(2, 0)).setEnabled(list.size() == 0);
                    ((EnumDropDown)cGrid.getWidget(2, 1)).setEnabled(list.size() == 0);
                    ((Button)cGrid.getWidget(0, 3)).setEnabled(list.size() != 2);
                    attributeCellTable.redraw();
                }
            }
        };
        ActionCell actionCell = new ActionCell("Remove", (ActionCell.Delegate)delegate);
        IdentityColumn actionColumn = new IdentityColumn((Cell)actionCell);
        reasonCodeColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Attribute, String>(){

            public void update(int index, Attribute object, String value) {
                object.setReasonCode(value);
                attributeCellTable.redraw();
            }
        });
        operatorColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Attribute, String>(){

            public void update(int index, Attribute object, String value) {
                object.setOperator(value);
                attributeCellTable.redraw();
            }
        });
        valueColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Attribute, String>(){

            public void update(int index, Attribute object, String value) {
                object.setValue(value);
                attributeCellTable.redraw();
            }
        });
        partialScoreColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Attribute, String>(){

            public void update(int index, Attribute object, String value) {
                try {
                    double d = Double.parseDouble(value);
                    object.setPartialScore(d);
                }
                catch (Exception e1) {
                    partialScoreCell.clearViewData((Object)object);
                }
                attributeCellTable.redraw();
            }
        });
        attributeCellTable.addColumn((Column)operatorColumn, "Operator");
        attributeCellTable.addColumn((Column)valueColumn, "Value");
        attributeCellTable.addColumn((Column)partialScoreColumn, "Partial Score");
        attributeCellTable.addColumn((Column)reasonCodeColumn, "Reason Code");
        attributeCellTable.addColumn((Column)actionColumn, "Actions");
        attributeCellTable.setWidth("100%", true);
        attributeCellTable.setColumnWidth((Column)operatorColumn, 5.0, Style.Unit.PCT);
        attributeCellTable.setColumnWidth((Column)valueColumn, 10.0, Style.Unit.PCT);
        attributeCellTable.setColumnWidth((Column)partialScoreColumn, 10.0, Style.Unit.PCT);
        attributeCellTable.setColumnWidth((Column)reasonCodeColumn, 10.0, Style.Unit.PCT);
        attributeCellTable.setColumnWidth((Column)actionColumn, 5.0, Style.Unit.PCT);
        ListDataProvider dataProvider = new ListDataProvider();
        dataProvider.addDataDisplay((HasData)attributeCellTable);
        this.characteristicsAttrMap.put(cGrid, (ListDataProvider<Attribute>)dataProvider);
        return attributeCellTable;
    }

    private String[] getEligibleFields(String factName, String[] types) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String clazz : this.sceModelFields.keySet()) {
            if (!clazz.equalsIgnoreCase(factName)) continue;
            block1: for (ModelField field : this.sceModelFields.get(clazz)) {
                String type = field.getClassName();
                if (type.lastIndexOf(".") > -1) {
                    type = type.substring(type.lastIndexOf(".") + 1);
                }
                for (String t : types) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    fields.add(field.getName() + " : " + type);
                    continue block1;
                }
            }
        }
        return fields.toArray(new String[0]);
    }

    private String getDataTypeForField(String factName, String fieldName) {
        for (String clazz : this.sceModelFields.keySet()) {
            if (!clazz.equalsIgnoreCase(factName)) continue;
            for (ModelField field : this.sceModelFields.get(clazz)) {
                if (!fieldName.equalsIgnoreCase(field.getName())) continue;
                String type = field.getClassName();
                if (type.endsWith("String")) {
                    type = "String";
                } else if (type.endsWith("Double")) {
                    type = "Double";
                } else if (type.endsWith("Integer")) {
                    type = "int";
                }
                return type;
            }
        }
        return null;
    }

    private EnumDropDown booleanEditor(String currentValue) {
        return new EnumDropDown(currentValue, new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
                boolean enabled = "true".equalsIgnoreCase(newValue);
                GuidedScorecardWidget.this.ddReasonCodeAlgo.setEnabled(enabled);
                GuidedScorecardWidget.this.tbBaselineScore.setEnabled(enabled);
                GuidedScorecardWidget.this.ddReasonCodeField.setEnabled(enabled);
                for (DirtyableFlexTable cGrid : GuidedScorecardWidget.this.characteristicsTables) {
                    ((TextBox)cGrid.getWidget(2, 2)).setEnabled(enabled);
                    ((TextBox)cGrid.getWidget(2, 3)).setEnabled(enabled);
                }
            }
        }, DropDownData.create((String[])new String[]{"false", "true"}));
    }

    private EnumDropDown dropDownEditor(DropDownData dropDownData, String currentValue) {
        return new EnumDropDown(currentValue, new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
            }
        }, dropDownData);
    }
}

