/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class DefaultIndexBuilder {
    private final String fileName;
    private Project project;
    private Package pkg;
    private String pkgName;
    private Set<IndexElementsGenerator> generators = new HashSet<IndexElementsGenerator>();

    public DefaultIndexBuilder(String fileName, Project project, Package pkg) {
        this.fileName = (String)PortablePreconditions.checkNotNull((String)"fileName", (Object)fileName);
        this.project = (Project)PortablePreconditions.checkNotNull((String)"project", (Object)project);
        this.pkg = (Package)PortablePreconditions.checkNotNull((String)"pkg", (Object)pkg);
    }

    public DefaultIndexBuilder addGenerator(IndexElementsGenerator generator) {
        this.generators.add((IndexElementsGenerator)PortablePreconditions.checkNotNull((String)"generator", (Object)generator));
        return this;
    }

    public Set<Pair<String, String>> build() {
        HashSet<Pair<String, String>> indexElements = new HashSet<Pair<String, String>>();
        for (IndexElementsGenerator generator : this.generators) {
            this.addIndexElements(indexElements, generator);
        }
        indexElements.add((Pair<String, String>)new Pair((Object)"filename", (Object)this.fileName));
        if (this.project != null && this.project.getRootPath() != null) {
            String s = this.project.getRootPath().toURI();
            indexElements.add((Pair<String, String>)new Pair((Object)"projectRoot", (Object)s));
            String projectName = this.project.getProjectName();
            if (projectName != null) {
                indexElements.add((Pair<String, String>)new Pair((Object)"projectName", (Object)projectName));
            }
        }
        if (this.pkgName == null) {
            this.pkgName = this.pkg.getPackageName();
        }
        if (this.pkg != null) {
            indexElements.add((Pair<String, String>)new Pair((Object)"packageName", (Object)this.pkgName));
        }
        return indexElements;
    }

    private void addIndexElements(Set<Pair<String, String>> indexElements, IndexElementsGenerator generator) {
        if (generator == null) {
            return;
        }
        List generatorsIndexElements = generator.toIndexElements();
        indexElements.addAll(generatorsIndexElements);
    }

    public void setPackageName(String pkgName) {
        this.pkgName = pkgName;
    }
}

