/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.builder;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

public abstract class AbstractQueryBuilder {
    public Query getQuery(ValueIndexTerm valueTerm) {
        PrefixQuery termQuery;
        String text = this.getText(valueTerm);
        Term term = new Term(valueTerm.getTerm(), text);
        switch (valueTerm.getSearchType()) {
            case PREFIX: {
                termQuery = new PrefixQuery(term);
                break;
            }
            case WILDCARD: {
                termQuery = new WildcardQuery(term);
                break;
            }
            case REGEXP: {
                termQuery = new RegexpQuery(term, 0);
                break;
            }
            case NORMAL: {
                termQuery = new TermQuery(term);
                break;
            }
            default: {
                throw new UnsupportedOperationException(ValueIndexTerm.TermSearchType.class.getSimpleName() + " value " + valueTerm.getSearchType().toString() + " is unsupported!");
            }
        }
        return termQuery;
    }

    private String getText(ValueIndexTerm term) {
        return term.getValue().toLowerCase();
    }
}

