/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.AbstractQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

public class MultipleTermQueryBuilder
extends AbstractQueryBuilder
implements QueryBuilder<MultipleTermQueryBuilder> {
    private final List<ValueIndexTerm> terms = new ArrayList<ValueIndexTerm>();

    @Override
    public MultipleTermQueryBuilder addTerm(ValueIndexTerm term) {
        this.terms.add(term);
        return this;
    }

    @Override
    public Query build() {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (ValueIndexTerm valueTerm : this.terms) {
            Query termQuery = this.getQuery(valueTerm);
            queryBuilder.add(termQuery, BooleanClause.Occur.MUST);
        }
        BooleanQuery query = queryBuilder.build();
        return query;
    }
}

