/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.StringUtils;

@Named
public class DefaultMavenExecutionRequestPopulator
implements MavenExecutionRequestPopulator {
    private final MavenRepositorySystem repositorySystem;

    @Inject
    public DefaultMavenExecutionRequestPopulator(MavenRepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    @Override
    public MavenExecutionRequest populateFromToolchains(MavenExecutionRequest request, PersistedToolchains toolchains) throws MavenExecutionRequestPopulationException {
        if (toolchains != null) {
            HashMap<String, List<ToolchainModel>> groupedToolchains = new HashMap<String, List<ToolchainModel>>(2);
            for (ToolchainModel model : toolchains.getToolchains()) {
                if (!groupedToolchains.containsKey(model.getType())) {
                    groupedToolchains.put(model.getType(), new ArrayList());
                }
                ((List)groupedToolchains.get(model.getType())).add(model);
            }
            request.setToolchains(groupedToolchains);
        }
        return request;
    }

    @Override
    public MavenExecutionRequest populateDefaults(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        this.baseDirectory(request);
        this.localRepository(request);
        this.populateDefaultPluginGroups(request);
        this.injectDefaultRepositories(request);
        this.injectDefaultPluginRepositories(request);
        return request;
    }

    private void populateDefaultPluginGroups(MavenExecutionRequest request) {
        request.addPluginGroup("org.apache.maven.plugins");
        request.addPluginGroup("org.codehaus.mojo");
    }

    private void injectDefaultRepositories(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        Set<String> definedRepositories = this.repositorySystem.getRepoIds(request.getRemoteRepositories());
        if (!definedRepositories.contains("central")) {
            try {
                request.addRemoteRepository(this.repositorySystem.createDefaultRemoteRepository(request));
            }
            catch (Exception e) {
                throw new MavenExecutionRequestPopulationException("Cannot create default remote repository.", e);
            }
        }
    }

    private void injectDefaultPluginRepositories(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        Set<String> definedRepositories = this.repositorySystem.getRepoIds(request.getPluginArtifactRepositories());
        if (!definedRepositories.contains("central")) {
            try {
                request.addPluginArtifactRepository(this.repositorySystem.createDefaultRemoteRepository(request));
            }
            catch (Exception e) {
                throw new MavenExecutionRequestPopulationException("Cannot create default remote repository.", e);
            }
        }
    }

    private void localRepository(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        if (request.getLocalRepository() == null) {
            request.setLocalRepository(this.createLocalRepository(request));
        }
        if (request.getLocalRepositoryPath() == null) {
            request.setLocalRepositoryPath(new File(request.getLocalRepository().getBasedir()).getAbsoluteFile());
        }
    }

    private ArtifactRepository createLocalRepository(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        String localRepositoryPath = null;
        if (request.getLocalRepositoryPath() != null) {
            localRepositoryPath = request.getLocalRepositoryPath().getAbsolutePath();
        }
        if (StringUtils.isEmpty(localRepositoryPath)) {
            localRepositoryPath = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        try {
            return this.repositorySystem.createLocalRepository(request, new File(localRepositoryPath));
        }
        catch (Exception e) {
            throw new MavenExecutionRequestPopulationException("Cannot create local repository.", e);
        }
    }

    private void baseDirectory(MavenExecutionRequest request) {
        if (request.getBaseDirectory() == null && request.getPom() != null) {
            request.setBaseDirectory(request.getPom().getAbsoluteFile().getParentFile());
        }
    }

    @Override
    @Deprecated
    public MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenExecutionRequestPopulationException {
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            server = server.clone();
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            proxy = proxy.clone();
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            mirror = mirror.clone();
            request.addMirror(mirror);
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile(rawProfile));
            if (!settings.getActiveProfiles().contains(rawProfile.getId())) continue;
            List remoteRepositories = rawProfile.getRepositories();
            for (Repository remoteRepository : remoteRepositories) {
                try {
                    request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository(remoteRepository));
                }
                catch (InvalidRepositoryException e) {}
            }
            List pluginRepositories = rawProfile.getPluginRepositories();
            for (Repository pluginRepo : pluginRepositories) {
                try {
                    request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository(pluginRepo));
                }
                catch (InvalidRepositoryException e) {}
            }
        }
        return request;
    }
}

